/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.filters;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;

public class PDFFilterParamData
extends PDFCosObject {
    public boolean isBoolean() {
        return this.getCosObject() instanceof CosBoolean;
    }

    public boolean isName() {
        return this.getCosObject() instanceof CosName;
    }

    public boolean isStream() {
        return this.getCosObject() instanceof CosStream;
    }

    public boolean isNumber() {
        return this.getCosObject() instanceof CosNumeric;
    }

    public boolean isArray() {
        return this.getCosObject() instanceof CosArray;
    }

    private PDFFilterParamData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    static PDFFilterParamData getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFilterParamData pdfObject = (PDFFilterParamData)PDFCosObject.getCachedInstance(cosObject, PDFFilterParamData.class);
        if (pdfObject == null) {
            pdfObject = new PDFFilterParamData(cosObject);
        }
        return pdfObject;
    }

    public boolean getBooleanValue() {
        return ((CosBoolean)this.getCosObject()).booleanValue();
    }

    public String getNameValue() {
        return ((CosName)this.getCosObject()).nameValue().asString(true);
    }

    public InputByteStream getStreamValue() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return ((CosStream)this.getCosObject()).getStreamDecoded();
    }

    public int getIntegerValue() {
        return ((CosNumeric)this.getCosObject()).intValue();
    }

    public double getDoubleValue() {
        return ((CosNumeric)this.getCosObject()).doubleValue();
    }

    public double[] getDoubleArrayValue() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return ((CosArray)this.getCosObject()).getArrayDouble();
    }
}

