/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public abstract class PDFBuildData
extends PDFCosDictionary {
    protected PDFBuildData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName swModuleName = this.getDictionaryNameValue(ASName.k_Name);
        if (swModuleName != null) {
            return swModuleName.asString(true);
        }
        return null;
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Name, name);
    }

    public String getDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASDate date = this.getDictionaryDateValue(ASName.k_Date);
        if (date != null) {
            return date.asString();
        }
        return null;
    }

    public void setDate(String date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (date == null) {
            this.removeValue(ASName.k_Date);
        } else {
            try {
                this.setDictionaryDateValue(ASName.k_Date, new ASDate(date));
            }
            catch (PDFParseException e) {
                throw new PDFInvalidDocumentException(e);
            }
        }
    }

    public String getRevNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValueAsString(ASName.k_R);
    }

    public void setRevNumber(String revNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (revNumber == null) {
                this.removeValue(ASName.k_R);
            } else {
                CosNumeric cosNum = PDFCosObject.newCosNumeric(this.getPDFDocument(), revNumber.getBytes());
                this.setDictionaryValue(ASName.k_R, cosNum);
            }
        }
        catch (PDFInvalidParameterException pDFInvalidParameterException) {
            // empty catch block
        }
    }

    public boolean getPreRelease() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_PreRelease)) {
            return this.getDictionaryBooleanValue(ASName.k_PreRelease);
        }
        return false;
    }

    public void setPreRelease(boolean preReleaseFlag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_PreRelease, preReleaseFlag);
    }

    public String[] getOS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray array = this.getDictionaryArrayValue(ASName.k_OS);
        if (array == null) {
            return null;
        }
        String[] osArray = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            osArray[i] = array.getName(i).asString();
        }
        return osArray;
    }

    public void setOS(String[] osNameArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (osNameArray == null) {
            this.removeValue(ASName.k_OS);
        } else {
            PDFDocument pdfDoc = this.getPDFDocument();
            CosArray array = PDFCosObject.newCosArray(pdfDoc);
            for (int i = 0; i < osNameArray.length; ++i) {
                CosName str = PDFCosObject.newCosName(pdfDoc, ASName.create(osNameArray[i]));
                array.add(str);
            }
            this.setDictionaryArrayValue(ASName.k_OS, array);
        }
    }

    public boolean getNonEFontNoWarn() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_NonEFontNoWarn)) {
            return this.getDictionaryBooleanValue(ASName.k_NonEFontNoWarn);
        }
        return false;
    }

    public void setNonEFontNoWarn(boolean flag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NonEFontNoWarn, flag);
    }

    public boolean getTrustedMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_TrustedMode)) {
            return this.getDictionaryBooleanValue(ASName.k_TrustedMode);
        }
        return false;
    }

    public void setTrustedMode(boolean trustedMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_TrustedMode, trustedMode);
    }

    public String getV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValueAsString(ASName.k_V);
    }

    public void setV(String versionNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosNum = null;
        try {
            cosNum = versionNumber != null ? PDFCosObject.newCosNumeric(this.getPDFDocument(), versionNumber.getBytes()) : null;
            this.setDictionaryValue(ASName.k_V, cosNum);
        }
        catch (PDFInvalidParameterException pDFInvalidParameterException) {
            // empty catch block
        }
    }
}

