/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.BitInputStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IO {
    private static final int DEFAULT_CHUNK_SIZE = 32768;
    private static final boolean USE_THREADLOCAL_BUFFER = true;
    private static ThreadLocal<byte[]> tlBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected synchronized byte[] initialValue() {
            return new byte[32768];
        }
    };

    private static byte[] getBuffer(boolean useThreadLocalBuffer) {
        if (useThreadLocalBuffer) {
            return tlBuffer.get();
        }
        return new byte[32768];
    }

    private IO() {
    }

    public static final long copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = IO.getBuffer(true);
        long bytesCopied = 0L;
        int bytes = 0;
        while ((bytes = is.read(buf)) != -1) {
            os.write(buf, 0, bytes);
            bytesCopied += (long)bytes;
        }
        return bytesCopied;
    }

    public static final long copy(InputStream is, long length, OutputStream os) throws IOException {
        return IO.copyInternal(is, length, os, true);
    }

    static long copyInternal(InputStream is, long length, OutputStream os, boolean useThreadLocalBuffer) throws IOException {
        byte[] buf = IO.getBuffer(useThreadLocalBuffer);
        long bytesToCopy = length;
        int bytesThisRead = 0;
        long bytesCopied = 0L;
        while (bytesToCopy > 0L && (bytesThisRead = is.read(buf, 0, bytesToCopy > (long)buf.length ? buf.length : (int)bytesToCopy)) != -1) {
            os.write(buf, 0, bytesThisRead);
            bytesToCopy -= (long)bytesThisRead;
            bytesCopied += (long)bytesThisRead;
        }
        return bytesCopied;
    }

    public static final long copy(BitInputStream is, OutputStream os, int bitsPerValue) throws IOException {
        byte[] buf = IO.getBuffer(true);
        long bytesCopied = 0L;
        int bytes = 0;
        while ((bytes = is.read(buf, bitsPerValue, buf.length)) != 0) {
            os.write(buf, 0, bytes);
            bytesCopied += (long)bytes;
        }
        return bytesCopied;
    }

    public static final long copy(BitInputStream is, long length, OutputStream os, int bitsPerValue) throws IOException {
        byte[] buf = IO.getBuffer(true);
        long bytesToCopy = length;
        int bytesThisRead = 0;
        long bytesCopied = 0L;
        while (bytesToCopy > 0L && (bytesThisRead = is.read(buf, bitsPerValue, bytesToCopy > (long)buf.length ? buf.length : (int)bytesToCopy)) != 0) {
            os.write(buf, 0, bytesThisRead);
            bytesToCopy -= (long)bytesThisRead;
            bytesCopied += (long)bytesThisRead;
        }
        return bytesCopied;
    }

    public static final long copy(InputByteStream is, OutputByteStream os) throws IOException {
        return IO.copy(is, 0L, is.length(), os);
    }

    public static final long copy(InputByteStream is, OutputStream os) throws IOException {
        return IO.copy(is, 0L, is.length(), os);
    }

    public static final long copy(InputByteStream is, long offset, long length, OutputByteStream os) throws IOException {
        byte[] buf = IO.getBuffer(true);
        is.seek(offset);
        long bytesToCopy = length;
        int bytesThisRead = 0;
        long bytesCopied = 0L;
        while (bytesToCopy > 0L && (bytesThisRead = is.read(buf)) != -1) {
            if ((long)bytesThisRead < bytesToCopy) {
                os.write(buf, 0, bytesThisRead);
                bytesToCopy -= (long)bytesThisRead;
                bytesCopied += (long)bytesThisRead;
                continue;
            }
            os.write(buf, 0, (int)bytesToCopy);
            bytesToCopy = 0L;
            bytesCopied += (long)bytesThisRead;
        }
        return bytesCopied;
    }

    public static final long copy(InputByteStream is, long offset, long length, OutputStream os, int blockSize) throws IOException {
        if (blockSize < 1) {
            throw new IOException("Block size can't be smaller than 1 byte.");
        }
        byte[] buf = null;
        buf = blockSize <= 32768 ? IO.getBuffer(true) : new byte[blockSize];
        is.seek(offset);
        long bytesToCopy = length;
        int bytesThisRead = 0;
        long bytesCopied = 0L;
        while ((bytesThisRead = is.read(buf, 0, blockSize)) != -1 && bytesToCopy > 0L) {
            if ((long)bytesThisRead < bytesToCopy) {
                os.write(buf, 0, bytesThisRead);
                bytesToCopy -= (long)bytesThisRead;
            } else {
                os.write(buf, 0, (int)bytesToCopy);
                bytesToCopy = 0L;
            }
            bytesCopied += (long)bytesThisRead;
        }
        return bytesCopied;
    }

    public static final long copy(InputByteStream is, long offset, long length, OutputStream os) throws IOException {
        return IO.copy(is, offset, length, os, 32768);
    }

    public static final byte[] longToByteArray(long value, int width) {
        byte[] bytes = new byte[width];
        while (--width >= 0) {
            bytes[width] = (byte)value;
            value >>= 8;
        }
        return bytes;
    }

    public static final byte[] inputByteStreamToArray(InputByteStream byteStream) throws IOException {
        int length = (int)byteStream.length();
        byte[] bytes = new byte[length];
        long len = byteStream.read(bytes);
        return (byte[])(len > 0L ? bytes : null);
    }

    public static long copy(InputStream is, OutputByteStream obs) throws IOException {
        byte[] buf = IO.getBuffer(true);
        int bytes = 0;
        long bytesCopied = 0L;
        while (is.available() > 0 && (bytes = is.read(buf)) != -1) {
            obs.write(buf, 0, bytes);
            bytesCopied += (long)bytes;
        }
        return bytesCopied;
    }

    public static int compareInputByteStreams(InputByteStream stream1, InputByteStream stream2) throws IOException {
        int b2;
        int b1;
        do {
            if ((b1 = stream1.read()) == (b2 = stream2.read())) continue;
            return b1 - b2;
        } while (b1 != -1);
        return b1 - b2;
    }
}

