/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Post
extends Table {
    private static final String[] macNames = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};

    protected Post(FontByteArray buffer) throws UnsupportedFontException, InvalidFontException, IOException {
        super(buffer);
        if (buffer.getSize() < 32) {
            throw new InvalidFontException("'post' table must be at least 32 bytes");
        }
        int majorVersion = this.getTableMajorVersion();
        if (majorVersion < 1 || 4 < majorVersion) {
            throw new UnsupportedFontException("'post' tables with major version " + majorVersion + " are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getItalicAngle() throws InvalidFontException {
        return this.data.getint32(4);
    }

    public int getUnderlinePosition() throws InvalidFontException {
        return this.data.getint16(8);
    }

    public int getUnderlineThickness() throws InvalidFontException {
        return this.data.getint16(10);
    }

    public boolean isFixedPitch() throws InvalidFontException {
        return this.data.getuint32(12) != 0L;
    }

    public int getNumberOfGlyphs() throws InvalidFontException {
        if (this.getTableMajorVersion() != 2) {
            return -1;
        }
        return this.data.getuint16(32);
    }

    public String getGlyphName(int gid) {
        try {
            switch (this.getTableMajorVersion()) {
                case 1: {
                    if (gid >= macNames.length) {
                        return null;
                    }
                    return macNames[gid];
                }
                case 2: {
                    if (this.getTableMinorVersion() < 5) {
                        int numberOfGlyphs = this.data.getuint16(32);
                        if (gid >= numberOfGlyphs) {
                            return null;
                        }
                        int position = this.data.getuint16(34 + gid * 2);
                        if (position < 258) {
                            return macNames[position];
                        }
                        int offset = 34 + numberOfGlyphs * 2;
                        for (int i = 258; i < position; ++i) {
                            int len = this.data.getuint8(offset);
                            offset += 1 + len;
                        }
                        int len = this.data.getuint8(offset);
                        char[] s = new char[len];
                        for (int i = 0; i < len; ++i) {
                            s[i] = (char)this.data.getuint8(++offset);
                        }
                        return new String(s);
                    }
                    int inc = this.data.getint8(34 + gid * 2);
                    return macNames[gid + inc];
                }
            }
            return null;
        }
        catch (InvalidFontException e) {
            return null;
        }
    }

    public int glyphName2gid(String name) throws InvalidFontException {
        switch (this.getTableMajorVersion()) {
            case 1: {
                for (int gid = 0; gid < macNames.length; ++gid) {
                    if (!macNames[gid].equals(name)) continue;
                    return gid;
                }
                return 0;
            }
            case 2: {
                int numberOfGlyphs = this.data.getuint16(32);
                for (int gid = 0; gid < numberOfGlyphs; ++gid) {
                    if (!name.equals(this.getGlyphName(gid))) continue;
                    return gid;
                }
                return 0;
            }
        }
        return 0;
    }

    public void subsetAndStreamForCFF(Map tables) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder postData = OTByteArray.getOTByteArrayBuilderInstance(32);
        postData.setuint32(0, 196608);
        postData.setuint32(4, this.data.getint32(4));
        postData.setuint16(8, this.data.getint16(8));
        postData.setuint16(10, this.data.getint16(10));
        postData.setuint32(12, this.data.getint32(12));
        postData.setuint32(16, 0);
        postData.setuint32(20, 0);
        postData.setuint32(24, 0);
        postData.setuint32(28, 0);
        tables.put(new Integer(1886352244), postData);
    }

    public void subsetAndStream(Subset subset, SubsetSimpleTrueType ttSubset, Map tables) throws UnsupportedFontException, InvalidFontException {
        if (ttSubset == null || this.getTableMajorVersion() > 2) {
            return;
        }
        int numGlyphs = subset.getNumGlyphs();
        OTByteArray.OTByteArrayBuilder postData = OTByteArray.getOTByteArrayBuilderInstance(34 + numGlyphs * 32);
        postData.setuint32(0, 131072);
        postData.setuint32(4, this.data.getint32(4));
        postData.setuint16(8, this.data.getint16(8));
        postData.setuint16(10, this.data.getint16(10));
        postData.setuint32(12, this.data.getint32(12));
        postData.setuint32(16, this.data.getint32(16));
        postData.setuint32(20, this.data.getint32(20));
        postData.setuint32(24, this.data.getint32(24));
        postData.setuint32(28, this.data.getint32(28));
        postData.setuint16(32, numGlyphs);
        int pascalOffset = 0;
        int pascalIndex = 258;
        int stringBase = 34 + numGlyphs * 2;
        for (int subsetGid = 0; subsetGid < subset.getNumGlyphs(); ++subsetGid) {
            String specialName;
            int gid = subset.getFullGid(subsetGid);
            int nameIndex = this.getMacName(gid);
            if (nameIndex < 0 && (specialName = this.getGlyphName(gid)) != null) {
                int len = specialName.length();
                postData.setuint8(stringBase + pascalOffset++, len);
                for (int i = 0; i < len; ++i) {
                    postData.setuint8(stringBase + pascalOffset++, specialName.charAt(i));
                }
                nameIndex = pascalIndex++;
            }
            postData.setuint16(34 + subsetGid * 2, nameIndex);
        }
        tables.put(new Integer(1886352244), postData);
    }

    private int getMacName(int gid) throws InvalidFontException {
        switch (this.getTableMajorVersion()) {
            case 1: {
                return gid;
            }
            case 2: {
                if (this.getTableMinorVersion() == 0) {
                    int numberOfGlyphs = this.data.getuint16(32);
                    if (gid >= numberOfGlyphs) {
                        return -1;
                    }
                    int position = this.data.getuint16(34 + gid * 2);
                    if (position < 258) {
                        return position;
                    }
                    return -1;
                }
                int inc = this.data.getint8(34 + gid * 2);
                return gid + inc;
            }
        }
        return -1;
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1886352244), newData);
    }
}

