/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.EndDateRecurrenceRange;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.NoEndRecurrenceRange;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.NumberedRecurrenceRange;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.RecurrenceRange;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;
import microsoft.exchange.webservices.data.security.XmlNodeType;

public class RecurrencePropertyDefinition
extends PropertyDefinition {
    public RecurrencePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    @Override
    public void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        RecurrenceRange range;
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, "Recurrence");
        Recurrence recurrence = null;
        reader.read(new XmlNodeType(1));
        if (reader.getLocalName().equals("RelativeYearlyRecurrence")) {
            recurrence = new Recurrence.RelativeYearlyPattern();
        } else if (reader.getLocalName().equals("AbsoluteYearlyRecurrence")) {
            recurrence = new Recurrence.YearlyPattern();
        } else if (reader.getLocalName().equals("RelativeMonthlyRecurrence")) {
            recurrence = new Recurrence.RelativeMonthlyPattern();
        } else if (reader.getLocalName().equals("AbsoluteMonthlyRecurrence")) {
            recurrence = new Recurrence.MonthlyPattern();
        } else if (reader.getLocalName().equals("DailyRecurrence")) {
            recurrence = new Recurrence.DailyPattern();
        } else if (reader.getLocalName().equals("DailyRegeneration")) {
            recurrence = new Recurrence.DailyRegenerationPattern();
        } else if (reader.getLocalName().equals("WeeklyRecurrence")) {
            recurrence = new Recurrence.WeeklyPattern();
        } else if (reader.getLocalName().equals("WeeklyRegeneration")) {
            recurrence = new Recurrence.WeeklyRegenerationPattern();
        } else if (reader.getLocalName().equals("MonthlyRegeneration")) {
            recurrence = new Recurrence.MonthlyRegenerationPattern();
        } else if (reader.getLocalName().equals("YearlyRegeneration")) {
            recurrence = new Recurrence.YearlyRegenerationPattern();
        } else {
            throw new ServiceXmlDeserializationException(String.format("Invalid recurrence pattern: (%s).", reader.getLocalName()));
        }
        recurrence.loadFromXml(reader, reader.getLocalName());
        reader.read(new XmlNodeType(1));
        if (reader.getLocalName().equals("NoEndRecurrence")) {
            range = new NoEndRecurrenceRange();
        } else if (reader.getLocalName().equals("EndDateRecurrence")) {
            range = new EndDateRecurrenceRange();
        } else if (reader.getLocalName().equals("NumberedRecurrence")) {
            range = new NumberedRecurrenceRange();
        } else {
            throw new ServiceXmlDeserializationException(String.format("Invalid recurrence range: (%s).", reader.getLocalName()));
        }
        range.loadFromXml(reader, reader.getLocalName());
        range.setupRecurrence(recurrence);
        reader.readEndElementIfNecessary(XmlNamespace.Types, "Recurrence");
        propertyBag.setObjectFromPropertyDefinition(this, recurrence);
    }

    @Override
    public void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Recurrence value = (Recurrence)propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            value.writeToXml(writer, "Recurrence");
        }
    }

    public Class<Recurrence> getType() {
        return Recurrence.class;
    }
}

