/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.Iterator;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.RuleError;
import microsoft.exchange.webservices.data.property.complex.RuleErrorCollection;
import microsoft.exchange.webservices.data.property.complex.RuleOperation;

public final class RuleOperationError
extends ComplexProperty
implements Iterable<RuleError> {
    private int operationIndex;
    private RuleOperation operation;
    private RuleErrorCollection ruleErrors;

    protected RuleOperationError() {
    }

    public RuleOperation getOperation() {
        return this.operation;
    }

    public int getCount() {
        return this.ruleErrors.getCount();
    }

    public RuleError getRuleError(int index) throws ArgumentOutOfRangeException {
        if (index < 0 || index >= this.getCount()) {
            throw new ArgumentOutOfRangeException("index");
        }
        return (RuleError)this.ruleErrors.getPropertyAtIndex(index);
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("OperationIndex")) {
            this.operationIndex = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("ValidationErrors")) {
            this.ruleErrors = new RuleErrorCollection();
            this.ruleErrors.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        return false;
    }

    public void setOperationByIndex(Iterator<RuleOperation> operations) {
        for (int i = 0; i <= this.operationIndex; ++i) {
            operations.next();
        }
        this.operation = operations.next();
    }

    @Override
    public Iterator<RuleError> iterator() {
        return this.ruleErrors.iterator();
    }
}

