/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import java.util.ArrayList;
import java.util.Collection;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.availability.FreeBusyViewType;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.property.complex.availability.CalendarEvent;
import microsoft.exchange.webservices.data.property.complex.availability.WorkingHours;

public final class AttendeeAvailability
extends ServiceResponse {
    private Collection<CalendarEvent> calendarEvents = new ArrayList<CalendarEvent>();
    private Collection<LegacyFreeBusyStatus> mergedFreeBusyStatus = new ArrayList<LegacyFreeBusyStatus>();
    private FreeBusyViewType viewType;
    private WorkingHours workingHours;

    public void loadFreeBusyViewFromXml(EwsServiceXmlReader reader, FreeBusyViewType viewType) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "FreeBusyView");
        String viewTypeString = reader.readElementValue(XmlNamespace.Types, "FreeBusyViewType");
        for (FreeBusyViewType o : (FreeBusyViewType[])FreeBusyViewType.class.getEnumConstants()) {
            if (!((Object)((Object)o)).toString().equals(viewTypeString)) continue;
            this.viewType = o;
            break;
        }
        do {
            reader.read();
            if (!reader.isStartElement()) continue;
            if (reader.getLocalName().equals("MergedFreeBusy")) {
                String mergedFreeBusy = reader.readElementValue();
                block2: for (int i = 0; i < mergedFreeBusy.length(); ++i) {
                    Byte b = Byte.parseByte(mergedFreeBusy.charAt(i) + "");
                    for (LegacyFreeBusyStatus legacyStatus : LegacyFreeBusyStatus.values()) {
                        if (b.byteValue() != legacyStatus.getBusyStatus()) continue;
                        this.mergedFreeBusyStatus.add(legacyStatus);
                        continue block2;
                    }
                }
            } else {
                if (reader.getLocalName().equals("CalendarEventArray")) {
                    do {
                        reader.read();
                        if (!reader.isStartElement(XmlNamespace.Types, "CalendarEvent")) continue;
                        CalendarEvent calendarEvent = new CalendarEvent();
                        calendarEvent.loadFromXml(reader, "CalendarEvent");
                        this.calendarEvents.add(calendarEvent);
                    } while (!reader.isEndElement(XmlNamespace.Types, "CalendarEventArray"));
                    continue;
                }
                if (!reader.getLocalName().equals("WorkingHours")) continue;
                this.workingHours = new WorkingHours();
                this.workingHours.loadFromXml(reader, reader.getLocalName());
                break;
            }
        } while (!reader.isEndElement(XmlNamespace.Messages, "FreeBusyView"));
    }

    public Collection<CalendarEvent> getCalendarEvents() {
        return this.calendarEvents;
    }

    public Collection<LegacyFreeBusyStatus> getMergedFreeBusyStatus() {
        return this.mergedFreeBusyStatus;
    }

    public FreeBusyViewType getViewType() {
        return this.viewType;
    }

    public WorkingHours getWorkingHours() {
        return this.workingHours;
    }
}

