/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.webdav.Utils;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeTaskTag;
import coldfusion.tagext.net.exchange.TaskConstants;
import coldfusion.tagext.net.exchange.TaskQuery;
import coldfusion.tagext.validation.RequiredAttributesException;
import java.util.ArrayList;
import java.util.Map;

public class TaskTagHelper
implements TaskConstants {
    public static void getTasks(ExchangeTaskTag tag) {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        TaskFilterInfo filter = tag.getFilterInfo();
        ArrayList results = null;
        try {
            results = con.getTasks(filter);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        TaskQuery queryResult = new TaskQuery();
        queryResult.populate(results);
        tag.getPageContext().setAttribute(tag.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    public static void saveTask(ExchangeTaskTag tag, Map task, boolean isNew) {
        String uidVarName;
        Float tmpFloat;
        if (!isNew && tag.getUid() != null && tag.getUid().indexOf(44) != -1) {
            ExchangeExceptions.throwMultipleUIDsInModifyActionException("cfexchangetask");
        }
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        Integer tmpInt = null;
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        ExchangeTask tsk = new ExchangeTask();
        tmpInt = tag.getIntAttribute(task, "ActualWork", false);
        if (tmpInt != null) {
            if (tmpInt < 0) {
                ExchangeExceptions.throwNegativeValueException("ActualWork");
            }
            tsk.setActualWork((int)tmpInt);
        }
        tsk.setBillingInfo(tag.getStringAttribute(task, "BillingInfo", false));
        tsk.setCompanies(tag.getStringAttribute(task, "Companies", false));
        tsk.setDateCompleted(tag.getDateAttribute(task, "DateCompleted", false));
        tsk.setDueDate(tag.getDateAttribute(task, "DueDate", false));
        String status = tag.getStringAttribute(task, "Status", false);
        if (status != null) {
            if (ExchangeTask.statusStringToInt(status) == -1) {
                ExchangeExceptions.throwInvalidTaskStatusException("Status");
            }
            tsk.setStatus(status);
        }
        if ((tmpFloat = tag.getFloatAttribute(task, "PercentCompleted", false)) != null) {
            if (tmpFloat.floatValue() < 0.0f) {
                ExchangeExceptions.throwInvalidAttributeValueException("PercentCompleted");
            }
            tsk.setPercentComplete(tmpFloat.floatValue());
        }
        tsk.setReminderDate(tag.getDateAttribute(task, "ReminderDate", false));
        tmpInt = tag.getIntAttribute(task, "TotalWork", false);
        if (tmpInt != null) {
            if (tmpInt < 0) {
                ExchangeExceptions.throwNegativeValueException("TotalWork");
            }
            tsk.setTotalWork((int)tmpInt);
        }
        tsk.setMileage(tag.getStringAttribute(task, "Mileage", false));
        tsk.setStartDate(tag.getDateAttribute(task, "StartDate", false));
        tsk.setSubject(tag.getStringAttribute(task, "Subject", false));
        tsk.setMessage(tag.getStringAttribute(task, "Message", false));
        tsk.setCategories(tag.getStringAttribute(task, "Categories", false));
        String strPriority = tag.getStringAttribute(task, "Priority", false);
        if (strPriority != null) {
            int priority = ExchangeTaskTag.stringPriorityToInt(strPriority);
            if (priority < 0) {
                ExchangeExceptions.throwInvalidPriorityException("Priority");
            }
            tsk.setPriority(priority);
        }
        String attachmentPaths = tag.getStringAttribute(task, "attachments", false);
        String[] attachedFileNames = null;
        Object[] attachedFilecontent = null;
        if (attachmentPaths != null) {
            Object[] tmpArray = tag.readAttachmentFiles(attachmentPaths);
            attachedFileNames = (String[])tmpArray[0];
            attachedFilecontent = (Object[])tmpArray[1];
        }
        if (!isNew) {
            String id = tag.getUid();
            if (id == null) {
                throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
            }
            tsk.setId(id);
        }
        try {
            if (isNew) {
                if (attachmentPaths != null) {
                    con.createTask(tsk, attachedFileNames, attachedFilecontent);
                } else {
                    con.createTask(tsk);
                }
            } else if (attachmentPaths != null) {
                con.modifyTask(tsk, attachedFileNames, attachedFilecontent);
            } else {
                con.modifyTask(tsk);
            }
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (isNew && (uidVarName = tag.getResult()) != null) {
            tag.getPageContext().setAttribute(uidVarName, (Object)tsk.getId());
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    static void deleteTasks(ExchangeTaskTag tag) {
        String uids;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = tag.getConnection(false);
        if (con == null) {
            con = tag.createConnection();
            getTempConnection = true;
        }
        if ((uids = tag.getUid()) == null) {
            throw new RequiredAttributesException(tag.getTagPublicName(), "uid");
        }
        String[] uidArray = Utils.splitString(uids);
        try {
            con.deleteTasks(uidArray);
        }
        catch (Throwable t) {
            tag.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }
}

