/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.webservice.InternetHeaders;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.MailQueryMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class MailQuery
extends QueryTable {
    public static final String MAIL_MESSAGE_TYPE = "Mail";
    public static final String CALENDAR_MESSAGE_TYPE = "Meeting";
    public static final String CALENDAR_REQUEST_MESSAGE_TYPE = "Meeting_Request";
    public static final String CALENDAR_RESPONSE_MESSAGE_TYPE = "Meeting_Response";
    public static final String CALENDAR_CANCEL_MESSAGE_TYPE = "Meeting_Cancel";

    public void populate(ArrayList resultArray) {
        this.meta = new MailQueryMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (resultArray == null || resultArray.size() == 0) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(resultArray.size());
        for (ExchangeMessage msg : resultArray) {
            Object[] colData = new Object[this.col_count];
            colData[0] = msg.getId();
            colData[1] = msg.getFromId();
            colData[2] = msg.getToId();
            colData[3] = msg.getCc();
            colData[4] = msg.getBcc();
            colData[5] = msg.getTimeReceived();
            colData[6] = msg.getTimeSent();
            colData[7] = msg.getSubject();
            colData[8] = msg.getMessage();
            colData[9] = msg.getHtmlMessage();
            colData[10] = msg.getImportance();
            colData[11] = msg.getSensitivity();
            colData[12] = msg.isRead();
            colData[13] = msg.getHasAttachment();
            colData[14] = msg.getFolder();
            int messageType = msg.getMessageType();
            String strType = null;
            String responseType = null;
            if (messageType == 1) {
                strType = MAIL_MESSAGE_TYPE;
            } else if (messageType == 3) {
                strType = CALENDAR_REQUEST_MESSAGE_TYPE;
            } else if (messageType == 4) {
                strType = CALENDAR_RESPONSE_MESSAGE_TYPE;
                responseType = msg.getMeetingResponseType();
            } else if (messageType == 5) {
                strType = CALENDAR_CANCEL_MESSAGE_TYPE;
            }
            colData[15] = strType;
            colData[16] = responseType;
            colData[17] = msg.getMeetingUID();
            colData[18] = msg.getLastModified() != null ? CFPage.CreateODBCDateTime((Object)msg.getLastModified()) : null;
            this.addRow(colData);
            InternetHeaders headers = msg.getHeaders();
            if (null == headers) continue;
            Struct internetHeaders = new Struct();
            Map<String, String[]> headersMap = headers.getHeaders();
            for (Map.Entry<String, String[]> entry : headersMap.entrySet()) {
                Array array = new Array();
                array.addAll(Arrays.asList(entry.getValue()));
                internetHeaders.put((Object)entry.getKey(), (Object)array);
            }
            colData[19] = internetHeaders;
        }
    }
}

