/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.consumer.SharedAccessBlobPolicyConsumer;
import coldfusion.azure.blob.request.AzureBlobContainerPermissions;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.runtime.Struct;
import com.microsoft.azure.storage.blob.BlobContainerPermissions;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AzureBlobContainerPermissionsConsumer
extends ConsumerMap<AzureBlobContainerPermissions> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static AzureBlobContainerPermissionsConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AzureBlobContainerPermissionsConsumer getInstance() {
        if (instance != null) return instance;
        Class<AzureBlobContainerPermissionsConsumer> clazz = AzureBlobContainerPermissionsConsumer.class;
        synchronized (AzureBlobContainerPermissionsConsumer.class) {
            instance = new AzureBlobContainerPermissionsConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AzureBlobContainerPermissionsConsumer() {
        this.put("publicAccessType", new ConsumerValidator((containerPermissions, value) -> {
            BlobContainerPermissions permissions = containerPermissions.getPermissions();
            permissions.setPublicAccess(BlobContainerPublicAccessType.valueOf((String)this.cast.getStringProperty(value)));
        }, Collections.emptyList()));
        this.put("sharedAccessPolicies", new ConsumerValidator((containerPermissions, value) -> {
            Map map = this.cast.getMapProperty(value);
            HashMap policyMap = new HashMap();
            map.forEach((k, v) -> {
                String key = this.cast.getStringProperty(k);
                SharedAccessBlobPolicyConsumer policyConsumer = SharedAccessBlobPolicyConsumer.getInstance();
                SharedAccessBlobPolicy blobPolicy = new SharedAccessBlobPolicy();
                ValidatorFiller.INSTANCE.fillObject((Object)blobPolicy, this.cast.getMapProperty(v), (ConsumerMap)policyConsumer);
                policyMap.put(key, blobPolicy);
            });
            BlobContainerPermissions permissions = containerPermissions.getPermissions();
            permissions.setSharedAccessPolicies(policyMap);
        }, Collections.emptyList()));
    }

    public Struct getAzureBlobContainerPermissionsStruct(BlobContainerPermissions permissions) {
        Struct struct = new Struct();
        struct.put((Object)"publicAccessType", (Object)permissions.getPublicAccess().name());
        Struct sharedAccessPolicies = new Struct();
        permissions.getSharedAccessPolicies().forEach((policyName, policy) -> sharedAccessPolicies.put(policyName, (Object)SharedAccessBlobPolicyConsumer.getInstance().getPolicyStruct((SharedAccessBlobPolicy)policy)));
        struct.put((Object)"sharedAccessPolicies", (Object)sharedAccessPolicies);
        return struct;
    }
}

