/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml.util;

import coldfusion.filter.FusionContext;
import coldfusion.saml.util.Utils;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.logout.LogoutResponse;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.settings.Saml2Settings;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringReader;
import java.security.Key;
import java.security.cert.X509Certificate;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SignatureVerifier {
    private static DocumentBuilderFactory dbf = Utils.createDocumentFactory();

    public boolean validateLogoutSignature(Saml2Settings settings) throws Throwable {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)FusionContext.getCurrent().getRequest());
        String samlResponseParameter = httpRequest.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            LogoutResponse logoutResponse = new LogoutResponse(settings, httpRequest);
            String responseXml = logoutResponse.getLogoutResponseXml();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(responseXml)));
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            if (nl.getLength() == 0) {
                throw new Exception("Cannot find Signature element");
            }
            Node signatureNode = null;
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!this.isLogoutResponseChildNode(nl.item(i))) continue;
                signatureNode = nl.item(i);
                break;
            }
            if (signatureNode == null) {
                throw new Exception("LogoutResponse node of the response is not signed.");
            }
            X509Certificate cert = null;
            cert = settings.getIdpx509certMulti() != null && settings.getIdpx509certMulti().size() > 0 ? (X509Certificate)settings.getIdpx509certMulti().get(0) : settings.getIdpx509cert();
            if (cert == null) {
                throw new Exception("Identity Provider sign certificate is not found");
            }
            DOMValidateContext valContext = new DOMValidateContext(new X509KeySelector(settings.getIdpx509cert().getPublicKey()), signatureNode);
            valContext.setIdAttributeNS((Element)signatureNode.getParentNode(), null, "ID");
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean coreValidity = signature.validate(valContext);
            return coreValidity;
        }
        return false;
    }

    private boolean isLogoutResponseChildNode(Node node) {
        String parentNodeName;
        return node != null && node.getParentNode() != null && ((parentNodeName = node.getParentNode().getNodeName()).equals("samlp:LogoutResponse") || parentNodeName.equals("saml2p:LogoutResponse"));
    }

    public class X509KeySelector
    extends KeySelector {
        Key key;

        public X509KeySelector(Key key) {
            this.key = key;
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (this.key != null) {
                return new KeySelectorResult(){

                    @Override
                    public Key getKey() {
                        return X509KeySelector.this.key;
                    }
                };
            }
            return null;
        }
    }
}

