/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import jakarta.activation.DataHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.attachments.AttachmentsDelegate;
import org.apache.axiom.attachments.CountingInputStream;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.attachments.LegacyPartDataHandler;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.DataHandlerFactory;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.mime.Part;
import org.apache.axiom.om.OMException;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class MultipartBodyAdapter
extends AttachmentsDelegate
implements MultipartBody.PartCreationListener {
    private static final Log log = LogFactory.getLog(MultipartBodyAdapter.class);
    private final MultipartBody message;
    private final Map<String, DataHandler> map = new LinkedHashMap<String, DataHandler>();
    private final int contentLength;
    private final CountingInputStream filterIS;
    private final Part rootPart;
    private final String rootPartContentID;
    private Iterator<Part> partIterator;
    private IncomingAttachmentStreams streams;

    MultipartBodyAdapter(InputStream inStream, String contentTypeString, WritableBlobFactory<?> attachmentBlobFactory, int contentLength) {
        this.contentLength = contentLength;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attachments contentLength=" + contentLength + ", contentTypeString=" + contentTypeString));
        }
        if (contentLength <= 0) {
            this.filterIS = new CountingInputStream(inStream);
            inStream = this.filterIS;
        } else {
            this.filterIS = null;
        }
        this.message = MultipartBody.builder().setInputStream(inStream).setContentType(contentTypeString).setAttachmentBlobFactory(attachmentBlobFactory).setDataHandlerFactory(new DataHandlerFactory(){

            @Override
            public DataHandler createDataHandler(Part part) {
                return new LegacyPartDataHandler(part);
            }
        }).setPartCreationListener(this).build();
        this.rootPart = this.message.getRootPart();
        String rootPartContentID = this.rootPart.getContentID();
        if (rootPartContentID == null) {
            rootPartContentID = "firstPart_" + UIDGenerator.generateContentId();
            this.map.put(rootPartContentID, this.rootPart.getDataHandler());
        }
        this.rootPartContentID = rootPartContentID;
    }

    @Override
    public void partCreated(Part part) {
        String contentID = part.getContentID();
        if (contentID != null) {
            this.map.put(contentID, part.getDataHandler());
        }
    }

    private boolean fetchNext() {
        if (this.streams != null) {
            throw new IllegalStateException("The attachments stream can only be accessed once; either by using the IncomingAttachmentStreams class or by getting a collection of AttachmentPart objects. They cannot both be called within the life time of the same service request.");
        }
        if (this.partIterator == null) {
            this.partIterator = this.message.iterator();
        }
        if (this.partIterator.hasNext()) {
            String contentID;
            Part part = this.partIterator.next();
            if (part != this.rootPart && (contentID = part.getContentID()) == null) {
                throw new OMException("Part content ID cannot be blank for non root MIME parts");
            }
            return true;
        }
        return false;
    }

    private void fetchAll() {
        while (this.fetchNext()) {
        }
    }

    @Override
    ContentType getContentType() {
        return this.message.getContentType();
    }

    @Override
    DataHandler getDataHandler(String contentID) {
        do {
            DataHandler dataHandler;
            if ((dataHandler = this.map.get(contentID)) == null) continue;
            return dataHandler;
        } while (this.fetchNext());
        return null;
    }

    @Override
    void addDataHandler(String contentID, DataHandler dataHandler) {
        this.fetchAll();
        this.map.put(contentID, dataHandler);
    }

    @Override
    void removeDataHandler(String contentID) {
        do {
            if (this.map.remove(contentID) == null) continue;
            return;
        } while (this.fetchNext());
    }

    @Override
    InputStream getRootPartInputStream(boolean preserve) {
        return this.rootPart.getInputStream(preserve);
    }

    @Override
    String getRootPartContentID() {
        return this.rootPartContentID;
    }

    @Override
    String getRootPartContentType() {
        return this.rootPart.getHeader("Content-Type");
    }

    @Override
    IncomingAttachmentStreams getIncomingAttachmentStreams() {
        if (this.partIterator != null) {
            throw new IllegalStateException("The attachments stream can only be accessed once; either by using the IncomingAttachmentStreams class or by getting a collection of AttachmentPart objects. They cannot both be called within the life time of the same service request.");
        }
        if (this.streams == null) {
            this.streams = new IncomingAttachmentStreams(this.message);
        }
        return this.streams;
    }

    @Override
    Set<String> getContentIDs(boolean fetchAll) {
        if (fetchAll) {
            this.fetchAll();
        }
        return this.map.keySet();
    }

    @Override
    Map<String, DataHandler> getMap() {
        this.fetchAll();
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    long getContentLength() throws IOException {
        if (this.contentLength > 0) {
            return this.contentLength;
        }
        this.fetchAll();
        return this.filterIS.getCount();
    }

    @Override
    MultipartBody getMultipartBody() {
        return this.message;
    }
}

