/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.log.Logger;
import coldfusion.nosql.NoSQLPasswordDecryptor;
import coldfusion.nosql.NoSQLServiceHandle;
import coldfusion.nosql.mongo.CFMongoClientSession;
import coldfusion.nosql.mongo.CFMongoDatabase;
import coldfusion.nosql.mongo.MongoClientSettingsBuilder;
import coldfusion.nosql.mongo.MongoException;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.cursor.CFMongoListDatabasesIterator;
import coldfusion.nosql.mongo.cursor.CFMongoListDatabasesIteratorImpl;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.server.ServiceFactory;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import jakarta.servlet.jsp.PageContext;
import java.util.Map;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class CFMongoServiceHandle
implements NoSQLServiceHandle,
NamedInvokable {
    private MongoClient mongoClient;
    private MongoClientSettings clientSettings;
    private volatile boolean isClosed;
    private Map dataSourceSettings;
    private NoSQLPasswordDecryptor passwordDecryptor;
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.mongo");
    private static InvokeNamedMethodInvocationMap<CFMongoServiceHandle> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public CFMongoServiceHandle(Object config) {
        this(config, true);
    }

    public CFMongoServiceHandle(Object config, boolean initService) {
        this(config, true, null);
    }

    public CFMongoServiceHandle(Object config, boolean initService, NoSQLPasswordDecryptor passwordDecryptor) {
        this.passwordDecryptor = passwordDecryptor;
        if (config instanceof Map) {
            this.dataSourceSettings = (Map)config;
            this.buildMongoClient((Map)config, initService);
        } else if (config instanceof String) {
            this.getSettings((String)config);
            if (initService) {
                this.mongoClient = MongoClients.create((MongoClientSettings)this.clientSettings);
            }
        }
    }

    public Map getDataSourceSettings() {
        return this.dataSourceSettings;
    }

    protected void buildMongoClient(Map<?, ?> configMap, boolean initService) {
        this.clientSettings = new MongoClientSettingsBuilder(configMap).withPasswordDecryptor(this.passwordDecryptor).buildSettings();
        if (initService) {
            this.mongoClient = MongoClients.create((MongoClientSettings)this.clientSettings);
        }
    }

    public Array listDBNames() {
        ListDatabasesIterable dbNamesItr = this.getMongoClient().listDatabases(Map.class).nameOnly(Boolean.TRUE);
        Array array = new Array();
        dbNamesItr.iterator().forEachRemaining(map -> array.add((Object)((String)map.get("name"))));
        return array;
    }

    public CFMongoDatabase db(String dbName) {
        try {
            MongoDatabase database = this.getMongoClient().getDatabase(dbName);
            return new CFMongoDatabase(database, this);
        }
        catch (IllegalArgumentException e) {
            throw new MongoException("IllegalDBName", e);
        }
    }

    public CFMongoListDatabasesIterator<Map> listDatabases() {
        return new CFMongoListDatabasesIteratorImpl<Map>(this.getMongoClient().listDatabases(Map.class));
    }

    public CFMongoClientSession startSession() {
        return new CFMongoClientSession(this.getMongoClient().startSession(), this);
    }

    public CFMongoClientSession startSession(Object clientSessionOptions) {
        if (clientSessionOptions == null) {
            return this.startSession();
        }
        if (clientSessionOptions instanceof Map) {
            ClientSessionOptions sessionOptions = MongoUtils.getClientSessionOptions((Map)clientSessionOptions);
            if (sessionOptions == null) {
                return this.startSession();
            }
            return new CFMongoClientSession(this.getMongoClient().startSession(sessionOptions), this);
        }
        boolean casualConsistency = Cast._boolean((Object)clientSessionOptions);
        return new CFMongoClientSession(this.getMongoClient().startSession(ClientSessionOptions.builder().causallyConsistent(casualConsistency).build()), this);
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoClient getMongoClient() {
        if (this.isClosed) {
            throw new MongoConnectionPoolClosedException();
        }
        MongoClient tmpClient = this.mongoClient;
        if (tmpClient == null) {
            CFMongoServiceHandle cFMongoServiceHandle = this;
            synchronized (cFMongoServiceHandle) {
                tmpClient = this.mongoClient;
                if (tmpClient == null) {
                    this.mongoClient = tmpClient = MongoClients.create((MongoClientSettings)this.clientSettings);
                }
            }
        }
        return tmpClient;
    }

    public CFMongoServiceHandle reOpen() {
        if (this.isClosed) {
            this.mongoClient = MongoClients.create((MongoClientSettings)this.clientSettings);
            this.isClosed = false;
        }
        return this;
    }

    private void getSettings(String connectionURL) {
        this.clientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionURL)).codecRegistry(MongoClientSettingsBuilder.DEFAULT_CODEC_REGISTRY).build();
    }

    public String getDBType() {
        return "mongodb";
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("mongo service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("mongo service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"getDataSourceSettings", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDataSourceSettings();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDataSourceSettings", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listDBNames", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listDBNames();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listDBNames", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"db", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"dbName"}, args);
                    return obj.db(Cast._String((Object)argColl.get((Object)"dbName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("db", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listDatabases", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listDatabases();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listDatabases", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"startSession", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.startSession();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"clientSessionOptions"}, args);
                    return obj.startSession(argColl.get((Object)"clientSessionOptions"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("startSession", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"close", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    obj.close();
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("close", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"isClosed", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.isClosed();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("isClosed", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"reOpen", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.reOpen();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("reOpen", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getDBType", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getDBType();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDBType", obj);
        });
    }

    public static class MongoConnectionPoolClosedException
    extends MongoException {
        private static final long serialVersionUID = 1L;

        public MongoConnectionPoolClosedException() {
            super("ConnectionClosed");
        }
    }
}

