/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.schedulers.RxThreadFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class SchedulerPoolFactory {
    static final String PURGE_ENABLED_KEY = "rx3.purge-enabled";
    public static final boolean PURGE_ENABLED;
    static final String PURGE_PERIOD_SECONDS_KEY = "rx3.purge-period-seconds";
    public static final int PURGE_PERIOD_SECONDS;
    static final AtomicReference<ScheduledExecutorService> PURGE_THREAD;
    static final Map<ScheduledThreadPoolExecutor, Object> POOLS;

    private SchedulerPoolFactory() {
        throw new IllegalStateException("No instances!");
    }

    public static void start() {
        SchedulerPoolFactory.tryStart(PURGE_ENABLED);
    }

    static void tryStart(boolean purgeEnabled) {
        if (purgeEnabled) {
            while (true) {
                ScheduledExecutorService curr;
                if ((curr = PURGE_THREAD.get()) != null) {
                    return;
                }
                ScheduledExecutorService next = Executors.newScheduledThreadPool(1, new RxThreadFactory("RxSchedulerPurge"));
                if (PURGE_THREAD.compareAndSet(curr, next)) {
                    next.scheduleAtFixedRate(new ScheduledTask(), PURGE_PERIOD_SECONDS, PURGE_PERIOD_SECONDS, TimeUnit.SECONDS);
                    return;
                }
                next.shutdownNow();
            }
        }
    }

    public static void shutdown() {
        ScheduledExecutorService exec = PURGE_THREAD.getAndSet(null);
        if (exec != null) {
            exec.shutdownNow();
        }
        POOLS.clear();
    }

    static int getIntProperty(boolean enabled, String key, int defaultNotFound, int defaultNotEnabled, Function<String, String> propertyAccessor) {
        if (enabled) {
            try {
                String value = propertyAccessor.apply(key);
                if (value == null) {
                    return defaultNotFound;
                }
                return Integer.parseInt(value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                return defaultNotFound;
            }
        }
        return defaultNotEnabled;
    }

    static boolean getBooleanProperty(boolean enabled, String key, boolean defaultNotFound, boolean defaultNotEnabled, Function<String, String> propertyAccessor) {
        if (enabled) {
            try {
                String value = propertyAccessor.apply(key);
                if (value == null) {
                    return defaultNotFound;
                }
                return "true".equals(value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                return defaultNotFound;
            }
        }
        return defaultNotEnabled;
    }

    public static ScheduledExecutorService create(ThreadFactory factory2) {
        ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, factory2);
        SchedulerPoolFactory.tryPutIntoPool(PURGE_ENABLED, exec);
        return exec;
    }

    static void tryPutIntoPool(boolean purgeEnabled, ScheduledExecutorService exec) {
        if (purgeEnabled && exec instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor e = (ScheduledThreadPoolExecutor)exec;
            POOLS.put(e, exec);
        }
    }

    static {
        PURGE_THREAD = new AtomicReference();
        POOLS = new ConcurrentHashMap<ScheduledThreadPoolExecutor, Object>();
        SystemPropertyAccessor propertyAccessor = new SystemPropertyAccessor();
        PURGE_ENABLED = SchedulerPoolFactory.getBooleanProperty(true, PURGE_ENABLED_KEY, true, true, propertyAccessor);
        PURGE_PERIOD_SECONDS = SchedulerPoolFactory.getIntProperty(PURGE_ENABLED, PURGE_PERIOD_SECONDS_KEY, 1, 1, propertyAccessor);
        SchedulerPoolFactory.start();
    }

    static final class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            for (ScheduledThreadPoolExecutor e : new ArrayList<ScheduledThreadPoolExecutor>(POOLS.keySet())) {
                if (e.isShutdown()) {
                    POOLS.remove(e);
                    continue;
                }
                e.purge();
            }
        }
    }

    static final class SystemPropertyAccessor
    implements Function<String, String> {
        SystemPropertyAccessor() {
        }

        @Override
        public String apply(String t) {
            return System.getProperty(t);
        }
    }
}

