/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.batch;

import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.internal.batch.BatchConfig;
import com.apollographql.apollo.internal.batch.BatchHttpCallFactory;
import com.apollographql.apollo.internal.batch.PeriodicJobScheduler;
import com.apollographql.apollo.internal.batch.PeriodicJobSchedulerImpl;
import com.apollographql.apollo.internal.batch.QueryToBatch;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo/internal/batch/BatchPoller;", "", "batchConfig", "Lcom/apollographql/apollo/internal/batch/BatchConfig;", "dispatcher", "Ljava/util/concurrent/Executor;", "batchHttpCallFactory", "Lcom/apollographql/apollo/internal/batch/BatchHttpCallFactory;", "logger", "Lcom/apollographql/apollo/api/internal/ApolloLogger;", "periodicJobScheduler", "Lcom/apollographql/apollo/internal/batch/PeriodicJobScheduler;", "(Lcom/apollographql/apollo/internal/batch/BatchConfig;Ljava/util/concurrent/Executor;Lcom/apollographql/apollo/internal/batch/BatchHttpCallFactory;Lcom/apollographql/apollo/api/internal/ApolloLogger;Lcom/apollographql/apollo/internal/batch/PeriodicJobScheduler;)V", "queryQueue", "Ljava/util/LinkedList;", "Lcom/apollographql/apollo/internal/batch/QueryToBatch;", "enqueue", "", "query", "maybeExecuteBatchQuery", "removeFromQueue", "start", "stop", "apollo-runtime"})
public final class BatchPoller {
    @NotNull
    private final BatchConfig batchConfig;
    @NotNull
    private final Executor dispatcher;
    @NotNull
    private final BatchHttpCallFactory batchHttpCallFactory;
    @NotNull
    private final ApolloLogger logger;
    @NotNull
    private final PeriodicJobScheduler periodicJobScheduler;
    @NotNull
    private final LinkedList<QueryToBatch> queryQueue;

    public BatchPoller(@NotNull BatchConfig batchConfig, @NotNull Executor dispatcher, @NotNull BatchHttpCallFactory batchHttpCallFactory, @NotNull ApolloLogger logger, @NotNull PeriodicJobScheduler periodicJobScheduler) {
        Intrinsics.checkParameterIsNotNull(batchConfig, "batchConfig");
        Intrinsics.checkParameterIsNotNull(dispatcher, "dispatcher");
        Intrinsics.checkParameterIsNotNull(batchHttpCallFactory, "batchHttpCallFactory");
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        Intrinsics.checkParameterIsNotNull(periodicJobScheduler, "periodicJobScheduler");
        this.batchConfig = batchConfig;
        this.dispatcher = dispatcher;
        this.batchHttpCallFactory = batchHttpCallFactory;
        this.logger = logger;
        this.periodicJobScheduler = periodicJobScheduler;
        this.queryQueue = new LinkedList();
    }

    public /* synthetic */ BatchPoller(BatchConfig batchConfig, Executor executor, BatchHttpCallFactory batchHttpCallFactory, ApolloLogger apolloLogger, PeriodicJobScheduler periodicJobScheduler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            periodicJobScheduler = new PeriodicJobSchedulerImpl();
        }
        this(batchConfig, executor, batchHttpCallFactory, apolloLogger, periodicJobScheduler);
    }

    public final void start() {
        this.stop();
        this.periodicJobScheduler.schedulePeriodicJob(0L, this.batchConfig.getBatchIntervalMs(), TimeUnit.MILLISECONDS, new Function0<Unit>(this){
            final /* synthetic */ BatchPoller this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                BatchPoller batchPoller = this.this$0;
                BatchPoller batchPoller2 = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (batchPoller) {
                    boolean bl3 = false;
                    BatchPoller.access$maybeExecuteBatchQuery(batchPoller2);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    public final void stop() {
        this.periodicJobScheduler.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(@NotNull QueryToBatch query) {
        Intrinsics.checkParameterIsNotNull(query, "query");
        if (!this.periodicJobScheduler.isRunning()) {
            throw new ApolloException("Trying to batch queries without calling ApolloClient.startBatchPoller() first");
        }
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            this.queryQueue.add(query);
            this.logger.d("Enqueued Query: " + query.getRequest().operation.name().name() + " for batching", new Object[0]);
            if (this.queryQueue.size() >= this.batchConfig.getMaxBatchSize()) {
                this.maybeExecuteBatchQuery();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFromQueue(@NotNull QueryToBatch query) {
        Intrinsics.checkParameterIsNotNull(query, "query");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            bl2 = this.queryQueue.remove(query);
        }
    }

    private final void maybeExecuteBatchQuery() {
        if (this.queryQueue.isEmpty()) {
            return;
        }
        ArrayList queryList = new ArrayList(this.queryQueue);
        this.queryQueue.clear();
        List batches = CollectionsKt.chunked(queryList, this.batchConfig.getMaxBatchSize());
        this.logger.d("Executing " + queryList.size() + " Queries in " + batches.size() + " Batch(es)", new Object[0]);
        for (List batch : batches) {
            this.dispatcher.execute(() -> BatchPoller.maybeExecuteBatchQuery$lambda-2(this, batch));
        }
    }

    private static final void maybeExecuteBatchQuery$lambda-2(BatchPoller this$0, List $batch) {
        Intrinsics.checkParameterIsNotNull(this$0, "this$0");
        Intrinsics.checkParameterIsNotNull($batch, "$batch");
        this$0.batchHttpCallFactory.createBatchHttpCall($batch).execute();
    }

    public static final /* synthetic */ void access$maybeExecuteBatchQuery(BatchPoller $this) {
        $this.maybeExecuteBatchQuery();
    }
}

