/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class PdfObjectCache {
    public static final int ColorspacesUsed = 1;
    public static final int Colorspaces = 2;
    public static final int ColorspacesObjects = 3;
    public static final int GlobalShadings = 4;
    public static final int LocalShadings = 5;
    private static final int initSize = 50;
    private final Map<Serializable, Object> colorspacesUsed = new HashMap<Serializable, Object>(50);
    private Map<String, byte[]> colorspaces = PdfObjectCache.getColorSpaceWithDefaultValues();
    private Map<String, Object> colorspaceObjects = new HashMap<String, Object>(50);
    private Map<Object, byte[]> globalXObjects = new HashMap<Object, byte[]>(50);
    private Map<Object, byte[]> localXObjects = new HashMap<Object, byte[]>(50);
    private final Map<String, byte[]> patterns = new HashMap<String, byte[]>(50);
    private final Map<String, byte[]> globalShadings = new HashMap<String, byte[]>(50);
    private Map<String, byte[]> localShadings = new HashMap<String, byte[]>(50);
    private final Map<String, Integer> imposedImages = new HashMap<String, Integer>(50);
    public PdfObject groupObj;
    private Map<Object, byte[]> OCRs = new HashMap<Object, byte[]>(50);
    public Map<Object, byte[]> unresolvedFonts = new HashMap<Object, byte[]>(50);
    public Map<String, PdfObject> directFonts = new HashMap<String, PdfObject>(50);
    public Map<String, PdfFont> resolvedFonts = new HashMap<String, PdfFont>(50);
    public Map<String, String> objRef2FontKey = new HashMap<String, String>(50);
    Map<Object, byte[]> GraphicsStates = new HashMap<Object, byte[]>(50);

    public PdfObjectCache copy() {
        PdfObjectCache copy = new PdfObjectCache();
        copy.localShadings = this.localShadings;
        copy.unresolvedFonts = this.unresolvedFonts;
        copy.GraphicsStates = this.GraphicsStates;
        copy.directFonts = this.directFonts;
        copy.resolvedFonts = this.resolvedFonts;
        copy.objRef2FontKey = this.objRef2FontKey;
        copy.colorspaces = this.colorspaces;
        copy.colorspaceObjects = this.colorspaceObjects;
        copy.OCRs = this.OCRs;
        copy.localXObjects = this.localXObjects;
        copy.globalXObjects = this.globalXObjects;
        copy.groupObj = this.groupObj;
        return copy;
    }

    public void put(int type, int key, Object value) {
        if (type == 1) {
            this.colorspacesUsed.put(Integer.valueOf(key), value);
        }
    }

    public void put(int type, String key, Object value) {
        if (type == 3) {
            this.colorspaceObjects.put(key, value);
        }
    }

    public Iterator<Serializable> iterator(int type) {
        Iterator<Serializable> returnValue = null;
        if (type == 1) {
            returnValue = this.colorspacesUsed.keySet().iterator();
        }
        return returnValue;
    }

    public Object get(int key, Object value) {
        Object returnValue = null;
        switch (key) {
            case 3: {
                returnValue = this.colorspaceObjects.get(value);
                break;
            }
            case 1: {
                returnValue = this.colorspacesUsed.get(value);
                break;
            }
            case 2: {
                returnValue = this.colorspaces.get(value);
                break;
            }
            case 4: {
                returnValue = this.globalShadings.get(value);
                break;
            }
            case 5: {
                returnValue = this.localShadings.get(value);
            }
        }
        return returnValue;
    }

    public void resetFonts() {
        this.resolvedFonts.clear();
        this.objRef2FontKey.clear();
        this.unresolvedFonts.clear();
        this.directFonts.clear();
    }

    public byte[] getProperties(String name) {
        return this.OCRs.get(name);
    }

    public byte[] getXObjects(String localName) {
        String convertedName = StringUtils.convertHexChars(localName);
        byte[] XObject2 = this.localXObjects.get(convertedName);
        if (XObject2 == null) {
            XObject2 = this.globalXObjects.get(convertedName);
        }
        return XObject2;
    }

    public void readResources(PdfObject Resources, boolean resetList, PdfFileReader objectReader) {
        int[] keys = new int[]{2087749783, -1938465939, -2089186617, 373243460, 1146450818, 878474856, 979194486};
        int length = keys.length;
        boolean verifyResourcesAvaiable = Resources.isDataExternal();
        for (int ii = 0; ii < length; ++ii) {
            PdfObject resObj = Resources.getDictionary(keys[ii]);
            if (resObj == null) continue;
            this.readArrayPairs(resObj, (keys[ii] == 373243460 || keys[ii] == 979194486) && resetList, keys[ii], objectReader, verifyResourcesAvaiable);
            if (!verifyResourcesAvaiable || resObj.isFullyResolved()) continue;
            Resources.setFullyResolved(false);
            ii = length;
        }
    }

    private void readArrayPairs(PdfObject resObj, boolean resetFontList, int type, PdfFileReader objectReader, boolean verifyResourcesAvaiable) {
        PdfKeyPairsIterator keyPairs = resObj.getKeyPairsIterator();
        while (keyPairs.hasMorePairs()) {
            String id = keyPairs.getNextKeyAsString();
            byte[] data = keyPairs.getNextValueAsBytes();
            if (verifyResourcesAvaiable && PdfObjectCache.cannotFullyLoadObjectAndChildren(data, type, objectReader, resObj)) {
                return;
            }
            switch (type) {
                case 2087749783: {
                    this.colorspaces.put(id, data);
                    break;
                }
                case -1938465939: {
                    this.GraphicsStates.put(id, data);
                    break;
                }
                case 373243460: {
                    if (id.contains("#")) {
                        id = StringUtils.convertHexChars(id);
                    }
                    this.unresolvedFonts.put(id, data);
                    break;
                }
                case 1146450818: {
                    this.patterns.put(id, data);
                    break;
                }
                case -2089186617: {
                    this.OCRs.put(id, data);
                    break;
                }
                case 878474856: {
                    if (resetFontList) {
                        this.globalShadings.put(id, data);
                        break;
                    }
                    this.localShadings.put(id, data);
                    break;
                }
                case 979194486: {
                    if (resetFontList) {
                        this.globalXObjects.put(StringUtils.convertHexChars(id), data);
                        break;
                    }
                    this.localXObjects.put(StringUtils.convertHexChars(id), data);
                }
            }
            keyPairs.nextPair();
        }
    }

    private static boolean cannotFullyLoadObjectAndChildren(byte[] data, int type, PdfFileReader objectReader, PdfObject resObj) {
        PdfObject pdfObject = ObjectFactory.createObject(type, 0, 0, type);
        pdfObject.setStatus(2);
        pdfObject.setUnresolvedData(data, type);
        pdfObject.isDataExternal(true);
        if (!ObjectDecoder.resolveFully(pdfObject, objectReader)) {
            resObj.setFullyResolved(false);
            return true;
        }
        return false;
    }

    public void reset(PdfObjectCache newCache) {
        this.localShadings = new HashMap<String, byte[]>(50);
        this.resolvedFonts = new HashMap<String, PdfFont>(50);
        this.objRef2FontKey = new HashMap<String, String>(50);
        this.unresolvedFonts = new HashMap<Object, byte[]>(50);
        this.directFonts = new HashMap<String, PdfObject>(50);
        this.colorspaces = PdfObjectCache.getColorSpaceWithDefaultValues();
        this.colorspaceObjects = new HashMap<String, Object>(50);
        this.GraphicsStates = new HashMap<Object, byte[]>(50);
        this.localXObjects = new HashMap<Object, byte[]>(50);
        this.OCRs = new HashMap<Object, byte[]>(50);
        Iterator<Object> keys = newCache.GraphicsStates.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.GraphicsStates.put(key, newCache.GraphicsStates.get(key));
        }
        Iterator<String> colorKeys = newCache.colorspaces.keySet().iterator();
        while (keys.hasNext()) {
            Object key = colorKeys.next();
            this.colorspaces.put((String)key, newCache.colorspaces.get(key));
        }
        for (Object key : newCache.localXObjects.keySet()) {
            this.localXObjects.put(key, newCache.localXObjects.get(key));
        }
        for (Object key : newCache.globalXObjects.keySet()) {
            this.globalXObjects.put(key, newCache.globalXObjects.get(key));
        }
        for (Object key : newCache.OCRs.keySet()) {
            this.OCRs.put(key, newCache.OCRs.get(key));
        }
        if (this.unresolvedFonts.isEmpty()) {
            for (Object key : newCache.unresolvedFonts.keySet()) {
                this.unresolvedFonts.put(key, newCache.unresolvedFonts.get(key));
            }
        }
    }

    public void restore(PdfObjectCache mainCache) {
        this.directFonts = mainCache.directFonts;
        this.unresolvedFonts = mainCache.unresolvedFonts;
        this.resolvedFonts = mainCache.resolvedFonts;
        this.objRef2FontKey = mainCache.objRef2FontKey;
        this.GraphicsStates = mainCache.GraphicsStates;
        this.colorspaces = mainCache.colorspaces;
        this.localShadings = mainCache.localShadings;
        this.localXObjects = mainCache.localXObjects;
        this.globalXObjects = mainCache.globalXObjects;
        this.colorspaceObjects = mainCache.colorspaceObjects;
        this.OCRs = mainCache.OCRs;
        this.groupObj = mainCache.groupObj;
    }

    public void setImposedKey(String key, int id) {
        this.imposedImages.put(key, id);
    }

    public Map<String, byte[]> getPatterns() {
        return Collections.unmodifiableMap(this.patterns);
    }

    private static Map<String, byte[]> getColorSpaceWithDefaultValues() {
        HashMap<String, byte[]> colorValues = new HashMap<String, byte[]>(50);
        String[] keys = new String[]{"DeviceRGB", "Pattern", "Separation", "CalRGB", "CalGray", "ICC", "DeviceGray", "DeviceN", "Lab", "DeviceCMYK"};
        String[] values = new String[]{"/DeviceRGB", "/Pattern", "/Separation", "/CalRGB", "/CalGray", "/ICC", "/DeviceGray", "/DeviceN", "/Lab", "/DeviceCMYK"};
        int keyCount = keys.length;
        for (int i = 0; i < keyCount; ++i) {
            colorValues.put(keys[i], values[i].getBytes());
        }
        return colorValues;
    }
}

