/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

public class FallbackFont {
    private final BaseType baseType;
    private final FontStyle fontStyle;

    FallbackFont(BaseType baseType, FontStyle fontStyle) {
        this.baseType = baseType;
        this.fontStyle = fontStyle;
    }

    public String getName() {
        return this.baseType.toString() + '-' + (Object)((Object)this.fontStyle);
    }

    public String getID() {
        return this.baseType.id + this.fontStyle.id;
    }

    public String getPath() {
        return this.baseType.path;
    }

    public boolean isUnicode() {
        return this.baseType.isUnicode;
    }

    public int getUnitsPerEm() {
        return this.baseType.unitsPerEm;
    }

    public static enum FontStyle {
        Regular("r"),
        Bold("b"),
        Italic("i"),
        BoldItalic("bi");

        private final String id;

        private FontStyle(String id) {
            this.id = id;
        }
    }

    public static enum BaseType {
        LiberationSerif(false, "liberation-serif", 2048, "lf"),
        LiberationSans(false, "liberation-sans", 2048, "ls"),
        NotoSansCondensed(false, "notosans-condensed", 1000, "n"),
        NotoSansSymbols2(false, "notosans-symbols2", 1000, "s"),
        Texgyrecursor(false, "texgyre_cursor", 1000, "t"),
        Unifont(true, "unifont", 1024, "u");

        private final boolean isUnicode;
        private final String path;
        private final int unitsPerEm;
        private final String id;

        private BaseType(boolean isUnicode, String path, int unitsPerEm, String id) {
            this.isUnicode = isUnicode;
            this.path = path;
            this.unitsPerEm = unitsPerEm;
            this.id = id;
        }
    }
}

