/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientRegistrationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class OIDCClientRegistrationRequest
extends ClientRegistrationRequest {
    public OIDCClientRegistrationRequest(URI uRI, OIDCClientMetadata oIDCClientMetadata, BearerAccessToken bearerAccessToken) {
        super(uRI, oIDCClientMetadata, bearerAccessToken);
    }

    public OIDCClientRegistrationRequest(URI uRI, OIDCClientMetadata oIDCClientMetadata, SignedJWT signedJWT, BearerAccessToken bearerAccessToken) {
        super(uRI, oIDCClientMetadata, signedJWT, bearerAccessToken);
    }

    public OIDCClientMetadata getOIDCClientMetadata() {
        return (OIDCClientMetadata)this.getClientMetadata();
    }

    public static OIDCClientRegistrationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jSONObject = hTTPRequest.getQueryAsJSONObject();
        SignedJWT signedJWT = null;
        if (jSONObject.containsKey("software_statement")) {
            try {
                signedJWT = SignedJWT.parse(JSONObjectUtils.getString(jSONObject, "software_statement"));
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid software statement JWT: " + parseException.getMessage());
            }
            jSONObject.remove("software_statement");
        }
        OIDCClientMetadata oIDCClientMetadata = OIDCClientMetadata.parse(jSONObject);
        BearerAccessToken bearerAccessToken = null;
        String string = hTTPRequest.getAuthorization();
        if (StringUtils.isNotBlank(string)) {
            bearerAccessToken = BearerAccessToken.parse(string);
        }
        URI uRI = hTTPRequest.getURI();
        try {
            return new OIDCClientRegistrationRequest(uRI, oIDCClientMetadata, signedJWT, bearerAccessToken);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

