/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.marks;

import java.net.URI;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.CommonClaimsSet;

public class TrustMarkClaimsSet
extends CommonClaimsSet {
    public static final String ID_CLAIM_NAME = "id";
    public static final String LOGO_URI_CLAIM_NAME = "logo_uri";
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String REF_CLAIM_NAME = "ref";

    public TrustMarkClaimsSet(Issuer issuer, Subject subject, Identifier identifier, Date date) {
        this.setClaim("iss", issuer.getValue());
        this.setClaim("sub", subject.getValue());
        this.setClaim(ID_CLAIM_NAME, identifier.getValue());
        this.setDateClaim("iat", date);
    }

    public TrustMarkClaimsSet(JWTClaimsSet jWTClaimsSet) throws ParseException {
        super(JSONObjectUtils.toJSONObject(jWTClaimsSet));
        this.validateRequiredClaimsPresence();
    }

    public void validateRequiredClaimsPresence() throws ParseException {
        if (this.getIssuer() == null) {
            throw new ParseException("Missing iss (issuer) claim");
        }
        if (this.getSubject() == null) {
            throw new ParseException("Missing sub (subject) claim");
        }
        if (this.getID() == null) {
            throw new ParseException("Missing id (identifier) claim");
        }
        if (this.getIssueTime() == null) {
            throw new ParseException("Missing iat (issued-at) claim");
        }
    }

    public Identifier getID() {
        String string = this.getStringClaim(ID_CLAIM_NAME);
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return new Identifier(string);
    }

    public URI getLogoURI() {
        return this.getURIClaim(LOGO_URI_CLAIM_NAME);
    }

    public void setMark(URI uRI) {
        this.setURIClaim(LOGO_URI_CLAIM_NAME, uRI);
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public void setExpirationTime(Date date) {
        this.setDateClaim(EXP_CLAIM_NAME, date);
    }

    public URI getReference() {
        return this.getURIClaim(REF_CLAIM_NAME);
    }

    public void setReference(URI uRI) {
        this.setURIClaim(REF_CLAIM_NAME, uRI);
    }
}

