/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import java.net.URI;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class FederationEntityMetadata {
    private URI federationFetchEndpoint;
    private URI federationListEndpoint;
    private URI federationResolveEndpoint;
    private URI federationTrustMarkStatusEndpoint;
    private String organizationName;
    private List<String> contacts;
    private URI logoURI;
    private URI policyURI;
    private URI homepageURI;

    public FederationEntityMetadata() {
    }

    public FederationEntityMetadata(URI uRI) {
        this.federationFetchEndpoint = uRI;
    }

    public URI getFederationFetchEndpointURI() {
        return this.federationFetchEndpoint;
    }

    public void setFederationFetchEndpointURI(URI uRI) {
        this.federationFetchEndpoint = uRI;
    }

    public URI getFederationListEndpointURI() {
        return this.federationListEndpoint;
    }

    public void setFederationListEndpointURI(URI uRI) {
        this.federationListEndpoint = uRI;
    }

    public URI getFederationResolveEndpointURI() {
        return this.federationResolveEndpoint;
    }

    public void setFederationResolveEndpointURI(URI uRI) {
        this.federationResolveEndpoint = uRI;
    }

    public URI getFederationTrustMarkStatusEndpointURI() {
        return this.federationTrustMarkStatusEndpoint;
    }

    public void setFederationTrustMarkStatusEndpointURI(URI uRI) {
        this.federationTrustMarkStatusEndpoint = uRI;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String string) {
        this.organizationName = string;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> list) {
        this.contacts = list;
    }

    public URI getLogoURI() {
        return this.logoURI;
    }

    public void setLogoURI(URI uRI) {
        this.logoURI = uRI;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI uRI) {
        this.policyURI = uRI;
    }

    public URI getHomepageURI() {
        return this.homepageURI;
    }

    public void setHomepageURI(URI uRI) {
        this.homepageURI = uRI;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.getFederationFetchEndpointURI() != null) {
            jSONObject.put("federation_fetch_endpoint", this.getFederationFetchEndpointURI().toString());
        }
        if (this.getFederationListEndpointURI() != null) {
            jSONObject.put("federation_list_endpoint", this.getFederationListEndpointURI().toString());
        }
        if (this.getFederationResolveEndpointURI() != null) {
            jSONObject.put("federation_resolve_endpoint", this.getFederationResolveEndpointURI().toString());
        }
        if (this.getFederationTrustMarkStatusEndpointURI() != null) {
            jSONObject.put("federation_trust_mark_status_endpoint", this.getFederationTrustMarkStatusEndpointURI().toString());
        }
        if (this.getOrganizationName() != null) {
            jSONObject.put("organization_name", this.getOrganizationName());
        }
        if (this.getContacts() != null) {
            jSONObject.put("contacts", this.getContacts());
        }
        if (this.getLogoURI() != null) {
            jSONObject.put("logo_uri", this.getLogoURI().toString());
        }
        if (this.getPolicyURI() != null) {
            jSONObject.put("policy_uri", this.getPolicyURI().toString());
        }
        if (this.getHomepageURI() != null) {
            jSONObject.put("homepage_uri", this.getHomepageURI().toString());
        }
        return jSONObject;
    }

    public static FederationEntityMetadata parse(JSONObject jSONObject) throws ParseException {
        FederationEntityMetadata federationEntityMetadata = new FederationEntityMetadata(JSONObjectUtils.getURI(jSONObject, "federation_fetch_endpoint", null));
        federationEntityMetadata.setFederationListEndpointURI(JSONObjectUtils.getURI(jSONObject, "federation_list_endpoint", null));
        federationEntityMetadata.setFederationResolveEndpointURI(JSONObjectUtils.getURI(jSONObject, "federation_resolve_endpoint", null));
        federationEntityMetadata.setFederationTrustMarkStatusEndpointURI(JSONObjectUtils.getURI(jSONObject, "federation_trust_mark_status_endpoint", null));
        federationEntityMetadata.setOrganizationName(JSONObjectUtils.getString(jSONObject, "organization_name", null));
        federationEntityMetadata.setContacts(JSONObjectUtils.getStringList(jSONObject, "contacts", null));
        federationEntityMetadata.setLogoURI(JSONObjectUtils.getURI(jSONObject, "logo_uri", null));
        federationEntityMetadata.setPolicyURI(JSONObjectUtils.getURI(jSONObject, "policy_uri", null));
        federationEntityMetadata.setHomepageURI(JSONObjectUtils.getURI(jSONObject, "homepage_uri", null));
        return federationEntityMetadata;
    }

    public static FederationEntityMetadata parse(String string) throws ParseException {
        return FederationEntityMetadata.parse(JSONObjectUtils.parse(string));
    }
}

