/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import java.net.URI;
import java.net.URISyntaxException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class EntityID
extends Identifier {
    private static final long serialVersionUID = -2884746939238001871L;

    public EntityID(URI uRI) {
        this(uRI.toString());
    }

    public EntityID(Issuer issuer) {
        this(issuer.getValue());
    }

    public EntityID(Subject subject) {
        this(subject.getValue());
    }

    public EntityID(ClientID clientID) {
        this(clientID.getValue());
    }

    public EntityID(String string) {
        super(string);
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("The entity ID must be an URI: " + uRISyntaxException.getMessage(), uRISyntaxException);
        }
        if (!"https".equalsIgnoreCase(uRI.getScheme()) && !"http".equalsIgnoreCase(uRI.getScheme())) {
            throw new IllegalArgumentException("The entity ID must be an URI with https or http scheme");
        }
        if (StringUtils.isBlank(uRI.getAuthority())) {
            throw new IllegalArgumentException("The entity ID must be an URI with authority (hostname)");
        }
    }

    public URI toURI() {
        return URI.create(this.getValue());
    }

    public Issuer toIssuer() {
        return new Issuer(this.getValue());
    }

    public Subject toSubject() {
        return new Subject(this.getValue());
    }

    public ClientID toClientID() {
        return new ClientID(this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof EntityID && this.toString().equals(object.toString());
    }

    public static EntityID parse(String string) throws ParseException {
        try {
            return new EntityID(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage());
        }
    }

    public static EntityID parse(Issuer issuer) throws ParseException {
        return EntityID.parse(issuer.getValue());
    }

    public static EntityID parse(Subject subject) throws ParseException {
        return EntityID.parse(subject.getValue());
    }

    public static EntityID parse(ClientID clientID) throws ParseException {
        return EntityID.parse(clientID.getValue());
    }
}

