/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class TrustMarkStatusRequest
extends FederationAPIRequest {
    private final Subject subject;
    private final Identifier id;
    private final Date iat;
    private final SignedJWT trustMark;

    public TrustMarkStatusRequest(URI uRI, Subject subject, Identifier identifier, Date date) {
        super(uRI);
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.subject = subject;
        if (identifier == null) {
            throw new IllegalArgumentException("The ID must not be null");
        }
        this.id = identifier;
        this.iat = date;
        this.trustMark = null;
    }

    public TrustMarkStatusRequest(URI uRI, SignedJWT signedJWT) {
        super(uRI);
        if (signedJWT == null) {
            throw new IllegalArgumentException("The trust mark must not be null");
        }
        this.trustMark = signedJWT;
        this.subject = null;
        this.id = null;
        this.iat = null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public EntityID getSubjectEntityID() {
        return this.subject != null ? new EntityID(this.subject) : null;
    }

    public Identifier getID() {
        return this.id;
    }

    public Date getIssueTime() {
        return this.iat;
    }

    public SignedJWT getTrustMark() {
        return this.trustMark;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        if (this.getSubject() != null) {
            linkedHashMap.put("sub", Collections.singletonList(this.getSubject().getValue()));
        }
        if (this.getID() != null) {
            linkedHashMap.put("id", Collections.singletonList(this.getID().getValue()));
        }
        if (this.getIssueTime() != null) {
            linkedHashMap.put("iat", Collections.singletonList(DateUtils.toSecondsSinceEpoch(this.getIssueTime()) + ""));
        }
        if (this.getTrustMark() != null) {
            linkedHashMap.put("trust_mark", Collections.singletonList(this.getTrustMark().serialize()));
        }
        return linkedHashMap;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        hTTPRequest.setBody(URLUtils.serializeParameters(this.toParameters()));
        return hTTPRequest;
    }

    public static TrustMarkStatusRequest parse(Map<String, List<String>> map) throws ParseException {
        Subject subject = null;
        String string = MultivaluedMapUtils.getFirstValue(map, "sub");
        if (StringUtils.isNotBlank(string)) {
            subject = new Subject(string);
        }
        Identifier identifier = null;
        string = MultivaluedMapUtils.getFirstValue(map, "id");
        if (StringUtils.isNotBlank(string)) {
            identifier = new Identifier(string);
        }
        Date date = null;
        string = MultivaluedMapUtils.getFirstValue(map, "iat");
        if (StringUtils.isNotBlank(string)) {
            try {
                date = DateUtils.fromSecondsSinceEpoch(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Illegal iat");
            }
        }
        SignedJWT signedJWT = null;
        string = MultivaluedMapUtils.getFirstValue(map, "trust_mark");
        if (StringUtils.isNotBlank(string)) {
            try {
                signedJWT = SignedJWT.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid trust mark: " + parseException.getMessage(), parseException);
            }
        }
        if (signedJWT != null) {
            return new TrustMarkStatusRequest(null, signedJWT);
        }
        try {
            return new TrustMarkStatusRequest(null, subject, identifier, date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Invalid request: " + illegalArgumentException.getMessage());
        }
    }

    public static TrustMarkStatusRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        TrustMarkStatusRequest trustMarkStatusRequest = TrustMarkStatusRequest.parse(hTTPRequest.getBodyAsFormParameters());
        if (trustMarkStatusRequest.getTrustMark() != null) {
            return new TrustMarkStatusRequest(hTTPRequest.getURI(), trustMarkStatusRequest.trustMark);
        }
        return new TrustMarkStatusRequest(hTTPRequest.getURI(), trustMarkStatusRequest.getSubject(), trustMarkStatusRequest.getID(), trustMarkStatusRequest.getIssueTime());
    }
}

