/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.EntityListingResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;

@Immutable
public class EntityListingSuccessResponse
extends EntityListingResponse {
    private final List<EntityID> entityIDS;

    public EntityListingSuccessResponse(List<EntityID> list) {
        if (list == null) {
            throw new IllegalArgumentException("The entity listing must not be null");
        }
        this.entityIDS = list;
    }

    public List<EntityID> getEntityListing() {
        return this.entityIDS;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONArray jSONArray = new JSONArray();
        for (EntityID entityID : this.getEntityListing()) {
            jSONArray.add(entityID.getValue());
        }
        hTTPResponse.setContent(jSONArray.toJSONString());
        return hTTPResponse;
    }

    public static EntityListingSuccessResponse parse(JSONArray jSONArray) {
        List<String> list = JSONArrayUtils.toStringList(jSONArray);
        LinkedList<EntityID> linkedList = new LinkedList<EntityID>();
        for (String string : list) {
            linkedList.add(new EntityID(string));
        }
        return new EntityListingSuccessResponse(linkedList);
    }

    public static EntityListingSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        return EntityListingSuccessResponse.parse(hTTPResponse.getBodyAsJSONArray());
    }
}

