/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class EntityListingRequest
extends FederationAPIRequest {
    private final EntityType entityType;

    public EntityListingRequest(URI uRI) {
        this(uRI, null);
    }

    public EntityListingRequest(URI uRI, EntityType entityType) {
        super(uRI);
        this.entityType = entityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.entityType != null) {
            hashMap.put("entity_type", Collections.singletonList(this.entityType.getValue()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        hTTPRequest.appendQueryParameters(this.toParameters());
        return hTTPRequest;
    }

    public static EntityListingRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        EntityType entityType = null;
        Map<String, List<String>> map = hTTPRequest.getQueryStringParameters();
        String string = MultivaluedMapUtils.getFirstValue(map, "entity_type");
        if (StringUtils.isNotBlank(string)) {
            entityType = new EntityType(string);
        }
        return new EntityListingRequest(URIUtils.getBaseURI(hTTPRequest.getURI()), entityType);
    }
}

