/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Display;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Nonce;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCResponseTypeValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Prompt;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ACR;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class AuthenticationRequest
extends AuthorizationRequest {
    public static final int PURPOSE_MIN_LENGTH = 3;
    public static final int PURPOSE_MAX_LENGTH = 300;
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Nonce nonce;
    private final Display display;
    private final int maxAge;
    private final List<LangTag> uiLocales;
    private final List<LangTag> claimsLocales;
    private final JWT idTokenHint;
    private final String loginHint;
    private final List<ACR> acrValues;
    private final OIDCClaimsRequest claims;
    private final String purpose;

    public AuthenticationRequest(URI uRI, ResponseType responseType, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce) {
        this(uRI, responseType, null, scope, clientID, uRI2, state, nonce, null, null, -1, null, null, null, null, null, (OIDCClaimsRequest)null, null, null, null, null, null, null, false, null);
    }

    @Deprecated
    public AuthenticationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce, Display display, Prompt prompt, int n2, List<LangTag> list, List<LangTag> list2, JWT jWT, String string, List<ACR> list3, ClaimsRequest claimsRequest, String string2, JWT jWT2, URI uRI3, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<URI> list4, boolean bl2, Map<String, List<String>> map) {
        this(uRI, responseType, responseMode, scope, clientID, uRI2, state, nonce, display, prompt, n2, list, list2, jWT, string, list3, AuthenticationRequest.toOIDCClaimsRequestWithSilentFail(claimsRequest), string2, jWT2, uRI3, codeChallenge, codeChallengeMethod, list4, bl2, map);
    }

    @Deprecated
    public AuthenticationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce, Display display, Prompt prompt, int n2, List<LangTag> list, List<LangTag> list2, JWT jWT, String string, List<ACR> list3, OIDCClaimsRequest oIDCClaimsRequest, String string2, JWT jWT2, URI uRI3, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<URI> list4, boolean bl2, Map<String, List<String>> map) {
        this(uRI, responseType, responseMode, scope, clientID, uRI2, state, nonce, display, prompt, null, null, n2, list, list2, jWT, string, list3, oIDCClaimsRequest, string2, jWT2, uRI3, codeChallenge, codeChallengeMethod, list4, bl2, map);
    }

    @Deprecated
    public AuthenticationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce, Display display, Prompt prompt, JWKThumbprintConfirmation jWKThumbprintConfirmation, int n2, List<LangTag> list, List<LangTag> list2, JWT jWT, String string, List<ACR> list3, OIDCClaimsRequest oIDCClaimsRequest, String string2, JWT jWT2, URI uRI3, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<URI> list4, boolean bl2, Map<String, List<String>> map) {
        this(uRI, responseType, responseMode, scope, clientID, uRI2, state, nonce, display, prompt, jWKThumbprintConfirmation, null, n2, list, list2, jWT, string, list3, oIDCClaimsRequest, string2, jWT2, uRI3, codeChallenge, codeChallengeMethod, list4, bl2, map);
    }

    @Deprecated
    public AuthenticationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce, Display display, Prompt prompt, JWKThumbprintConfirmation jWKThumbprintConfirmation, TrustChain trustChain, int n2, List<LangTag> list, List<LangTag> list2, JWT jWT, String string, List<ACR> list3, OIDCClaimsRequest oIDCClaimsRequest, String string2, JWT jWT2, URI uRI3, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<URI> list4, boolean bl2, Map<String, List<String>> map) {
        this(uRI, responseType, responseMode, scope, clientID, uRI2, state, nonce, display, prompt, jWKThumbprintConfirmation, trustChain, n2, list, list2, jWT, string, list3, oIDCClaimsRequest, string2, jWT2, uRI3, codeChallenge, codeChallengeMethod, null, list4, bl2, map);
    }

    public AuthenticationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, Scope scope, ClientID clientID, URI uRI2, State state, Nonce nonce, Display display, Prompt prompt, JWKThumbprintConfirmation jWKThumbprintConfirmation, TrustChain trustChain, int n2, List<LangTag> list, List<LangTag> list2, JWT jWT, String string, List<ACR> list3, OIDCClaimsRequest oIDCClaimsRequest, String string2, JWT jWT2, URI uRI3, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<AuthorizationDetail> list4, List<URI> list5, boolean bl2, Map<String, List<String>> map) {
        super(uRI, responseType, responseMode, clientID, uRI2, scope, state, codeChallenge, codeChallengeMethod, list4, list5, bl2, jWT2, uRI3, prompt, jWKThumbprintConfirmation, trustChain, map);
        if (!this.specifiesRequestObject()) {
            if (uRI2 == null) {
                throw new IllegalArgumentException("The redirection URI must not be null");
            }
            OIDCResponseTypeValidator.validate(responseType);
            if (scope == null) {
                throw new IllegalArgumentException("The scope must not be null");
            }
            if (!scope.contains(OIDCScopeValue.OPENID)) {
                throw new IllegalArgumentException("The scope must include an \"openid\" value");
            }
            if (nonce == null && Nonce.isRequired(responseType)) {
                throw new IllegalArgumentException("Nonce required for response_type=" + responseType);
            }
        }
        this.nonce = nonce;
        this.display = display;
        this.maxAge = n2;
        this.uiLocales = list != null ? Collections.unmodifiableList(list) : null;
        this.claimsLocales = list2 != null ? Collections.unmodifiableList(list2) : null;
        this.idTokenHint = jWT;
        this.loginHint = string;
        this.acrValues = list3 != null ? Collections.unmodifiableList(list3) : null;
        this.claims = oIDCClaimsRequest;
        if (string2 != null) {
            if (string2.length() < 3) {
                throw new IllegalArgumentException("The purpose must not be shorter than 3 characters");
            }
            if (string2.length() > 300) {
                throw new IllegalArgumentException("The purpose must not be longer than 300 characters");
            }
        }
        this.purpose = string2;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public Display getDisplay() {
        return this.display;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public List<ACR> getACRValues() {
        return this.acrValues;
    }

    @Deprecated
    public ClaimsRequest getClaims() {
        return AuthenticationRequest.toClaimsRequestWithSilentFail(this.claims);
    }

    private static OIDCClaimsRequest toOIDCClaimsRequestWithSilentFail(ClaimsRequest claimsRequest) {
        if (claimsRequest == null) {
            return null;
        }
        try {
            return OIDCClaimsRequest.parse(claimsRequest.toJSONObject());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static ClaimsRequest toClaimsRequestWithSilentFail(OIDCClaimsRequest oIDCClaimsRequest) {
        if (oIDCClaimsRequest == null) {
            return null;
        }
        try {
            return ClaimsRequest.parse(oIDCClaimsRequest.toJSONObject());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public OIDCClaimsRequest getOIDCClaims() {
        return this.claims;
    }

    public String getPurpose() {
        return this.purpose;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        Map<String, List<String>> map = super.toParameters();
        if (this.nonce != null) {
            map.put("nonce", Collections.singletonList(this.nonce.toString()));
        }
        if (this.display != null) {
            map.put("display", Collections.singletonList(this.display.toString()));
        }
        if (this.maxAge >= 0) {
            map.put("max_age", Collections.singletonList("" + this.maxAge));
        }
        if (this.uiLocales != null) {
            map.put("ui_locales", Collections.singletonList(LangTagUtils.concat(this.uiLocales)));
        }
        if (CollectionUtils.isNotEmpty(this.claimsLocales)) {
            map.put("claims_locales", Collections.singletonList(LangTagUtils.concat(this.claimsLocales)));
        }
        if (this.idTokenHint != null) {
            try {
                map.put("id_token_hint", Collections.singletonList(this.idTokenHint.serialize()));
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize ID token hint: " + illegalStateException.getMessage(), illegalStateException);
            }
        }
        if (this.loginHint != null) {
            map.put("login_hint", Collections.singletonList(this.loginHint));
        }
        if (this.acrValues != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ACR aCR : this.acrValues) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(aCR.toString());
            }
            map.put("acr_values", Collections.singletonList(stringBuilder.toString()));
        }
        if (this.claims != null) {
            map.put("claims", Collections.singletonList(this.claims.toJSONObject().toString()));
        }
        if (this.purpose != null) {
            map.put("purpose", Collections.singletonList(this.purpose));
        }
        return map;
    }

    @Override
    public JWTClaimsSet toJWTClaimsSet() {
        JWTClaimsSet jWTClaimsSet = super.toJWTClaimsSet();
        if (jWTClaimsSet.getClaim("max_age") != null) {
            try {
                String string = jWTClaimsSet.getStringClaim("max_age");
                JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder(jWTClaimsSet);
                builder.claim("max_age", Integer.parseInt(string));
                return builder.build();
            }
            catch (java.text.ParseException parseException) {
                throw new SerializeException(parseException.getMessage());
            }
        }
        return jWTClaimsSet;
    }

    public static AuthenticationRequest parse(Map<String, List<String>> map) throws ParseException {
        return AuthenticationRequest.parse(null, map);
    }

    public static AuthenticationRequest parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        String string;
        Object object;
        List list;
        List list2;
        AuthorizationRequest authorizationRequest = AuthorizationRequest.parse(uRI, map);
        Nonce nonce = Nonce.parse(MultivaluedMapUtils.getFirstValue(map, "nonce"));
        if (!authorizationRequest.specifiesRequestObject()) {
            if (authorizationRequest.getRedirectionURI() == null) {
                String string2 = "Missing redirect_uri parameter";
                throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2), authorizationRequest.getClientID(), null, authorizationRequest.impliedResponseMode(), authorizationRequest.getState());
            }
            if (authorizationRequest.getScope() == null) {
                String string3 = "Missing scope parameter";
                throw new ParseException(string3, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string3), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState());
            }
            if (nonce == null && Nonce.isRequired(authorizationRequest.getResponseType())) {
                String string4 = "Missing nonce parameter: Required for response_type=" + authorizationRequest.getResponseType();
                throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState());
            }
        }
        if (authorizationRequest.getResponseType() != null) {
            try {
                OIDCResponseTypeValidator.validate(authorizationRequest.getResponseType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string5 = "Unsupported response_type parameter: " + illegalArgumentException.getMessage();
                throw new ParseException(string5, OAuth2Error.UNSUPPORTED_RESPONSE_TYPE.appendDescription(": " + string5), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState());
            }
        }
        if (authorizationRequest.getScope() != null && !authorizationRequest.getScope().contains(OIDCScopeValue.OPENID)) {
            String string6 = "The scope must include an openid value";
            throw new ParseException(string6, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string6), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState());
        }
        Display display = null;
        if (map.containsKey("display")) {
            try {
                display = Display.parse(MultivaluedMapUtils.getFirstValue(map, "display"));
            }
            catch (ParseException parseException) {
                String string7 = "Invalid display parameter: " + parseException.getMessage();
                throw new ParseException(string7, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string7), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState(), parseException);
            }
        }
        String string8 = MultivaluedMapUtils.getFirstValue(map, "max_age");
        int n2 = -1;
        if (StringUtils.isNotBlank(string8)) {
            try {
                n2 = Integer.parseInt(string8);
            }
            catch (NumberFormatException numberFormatException) {
                String string9 = "Invalid max_age parameter: " + string8;
                throw new ParseException(string9, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string9), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState(), numberFormatException);
            }
        }
        try {
            list2 = LangTagUtils.parseLangTagList((String)MultivaluedMapUtils.getFirstValue(map, "ui_locales"));
        }
        catch (LangTagException langTagException) {
            String string10 = "Invalid ui_locales parameter: " + langTagException.getMessage();
            throw new ParseException(string10, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string10), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState(), langTagException);
        }
        try {
            list = LangTagUtils.parseLangTagList((String)MultivaluedMapUtils.getFirstValue(map, "claims_locales"));
        }
        catch (LangTagException langTagException) {
            String string11 = "Invalid claims_locales parameter: " + langTagException.getMessage();
            throw new ParseException(string11, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string11), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState(), langTagException);
        }
        string8 = MultivaluedMapUtils.getFirstValue(map, "id_token_hint");
        JWT jWT = null;
        if (StringUtils.isNotBlank(string8)) {
            try {
                jWT = JWTParser.parse(string8);
            }
            catch (java.text.ParseException parseException) {
                String string12 = "Invalid id_token_hint parameter: " + parseException.getMessage();
                throw new ParseException(string12, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string12), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState(), parseException);
            }
        }
        String string13 = MultivaluedMapUtils.getFirstValue(map, "login_hint");
        string8 = MultivaluedMapUtils.getFirstValue(map, "acr_values");
        LinkedList<ACR> linkedList = null;
        if (StringUtils.isNotBlank(string8)) {
            linkedList = new LinkedList<ACR>();
            object = new StringTokenizer(string8, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                linkedList.add(new ACR(((StringTokenizer)object).nextToken()));
            }
        }
        string8 = MultivaluedMapUtils.getFirstValue(map, "claims");
        object = null;
        if (StringUtils.isNotBlank(string8)) {
            try {
                object = OIDCClaimsRequest.parse(string8);
            }
            catch (ParseException parseException) {
                String string14 = "Invalid claims parameter: " + parseException.getMessage();
                throw new ParseException(string14, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string14), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState(), parseException);
            }
        }
        if ((string = MultivaluedMapUtils.getFirstValue(map, "purpose")) != null && (string.length() < 3 || string.length() > 300)) {
            String string15 = "Invalid purpose parameter: Must not be shorter than 3 and longer than 300 characters";
            throw new ParseException(string15, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string15), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState());
        }
        HashMap<String, List<String>> hashMap = null;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, List<String>>();
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return new AuthenticationRequest(uRI, authorizationRequest.getResponseType(), authorizationRequest.getResponseMode(), authorizationRequest.getScope(), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.getState(), nonce, display, authorizationRequest.getPrompt(), authorizationRequest.getDPoPJWKThumbprintConfirmation(), authorizationRequest.getTrustChain(), n2, list2, list, jWT, string13, linkedList, (OIDCClaimsRequest)object, string, authorizationRequest.getRequestObject(), authorizationRequest.getRequestURI(), authorizationRequest.getCodeChallenge(), authorizationRequest.getCodeChallengeMethod(), authorizationRequest.getAuthorizationDetails(), authorizationRequest.getResources(), authorizationRequest.includeGrantedScopes(), hashMap);
    }

    public static AuthenticationRequest parse(String string) throws ParseException {
        return AuthenticationRequest.parse(null, URLUtils.parseParameters(string));
    }

    public static AuthenticationRequest parse(URI uRI, String string) throws ParseException {
        return AuthenticationRequest.parse(uRI, URLUtils.parseParameters(string));
    }

    public static AuthenticationRequest parse(URI uRI) throws ParseException {
        return AuthenticationRequest.parse(URIUtils.getBaseURI(uRI), URLUtils.parseParameters(uRI.getRawQuery()));
    }

    public static AuthenticationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing URI query string");
        }
        URI uRI = hTTPRequest.getURI();
        return AuthenticationRequest.parse(uRI, string);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(AuthorizationRequest.getRegisteredParameterNames());
        hashSet.add("nonce");
        hashSet.add("display");
        hashSet.add("max_age");
        hashSet.add("ui_locales");
        hashSet.add("claims_locales");
        hashSet.add("id_token_hint");
        hashSet.add("login_hint");
        hashSet.add("acr_values");
        hashSet.add("claims");
        hashSet.add("purpose");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private URI uri;
        private ResponseType rt;
        private final ClientID clientID;
        private URI redirectURI;
        private Scope scope;
        private State state;
        private Nonce nonce;
        private Display display;
        private Prompt prompt;
        private JWKThumbprintConfirmation dpopJKT;
        private TrustChain trustChain;
        private int maxAge = -1;
        private List<LangTag> uiLocales;
        private List<LangTag> claimsLocales;
        private JWT idTokenHint;
        private String loginHint;
        private List<ACR> acrValues;
        private OIDCClaimsRequest claims;
        private String purpose;
        private JWT requestObject;
        private URI requestURI;
        private ResponseMode rm;
        private CodeChallenge codeChallenge;
        private CodeChallengeMethod codeChallengeMethod;
        private List<AuthorizationDetail> authorizationDetails;
        private List<URI> resources;
        private boolean includeGrantedScopes;
        private final Map<String, List<String>> customParams = new HashMap<String, List<String>>();

        public Builder(ResponseType responseType, Scope scope, ClientID clientID, URI uRI) {
            if (responseType == null) {
                throw new IllegalArgumentException("The response type must not be null");
            }
            OIDCResponseTypeValidator.validate(responseType);
            this.rt = responseType;
            if (scope == null) {
                throw new IllegalArgumentException("The scope must not be null");
            }
            if (!scope.contains(OIDCScopeValue.OPENID)) {
                throw new IllegalArgumentException("The scope must include an \"openid\" value");
            }
            this.scope = scope;
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
            this.redirectURI = uRI;
        }

        public Builder(JWT jWT, ClientID clientID) {
            if (jWT == null) {
                throw new IllegalArgumentException("The request object must not be null");
            }
            this.requestObject = jWT;
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
        }

        public Builder(URI uRI, ClientID clientID) {
            if (uRI == null) {
                throw new IllegalArgumentException("The request URI must not be null");
            }
            this.requestURI = uRI;
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
        }

        public Builder(AuthenticationRequest authenticationRequest) {
            this.uri = authenticationRequest.getEndpointURI();
            this.rt = authenticationRequest.getResponseType();
            this.clientID = authenticationRequest.getClientID();
            this.redirectURI = authenticationRequest.getRedirectionURI();
            this.scope = authenticationRequest.getScope();
            this.state = authenticationRequest.getState();
            this.nonce = authenticationRequest.getNonce();
            this.display = authenticationRequest.getDisplay();
            this.prompt = authenticationRequest.getPrompt();
            this.dpopJKT = authenticationRequest.getDPoPJWKThumbprintConfirmation();
            this.trustChain = authenticationRequest.getTrustChain();
            this.maxAge = authenticationRequest.getMaxAge();
            this.uiLocales = authenticationRequest.getUILocales();
            this.claimsLocales = authenticationRequest.getClaimsLocales();
            this.idTokenHint = authenticationRequest.getIDTokenHint();
            this.loginHint = authenticationRequest.getLoginHint();
            this.acrValues = authenticationRequest.getACRValues();
            this.claims = authenticationRequest.getOIDCClaims();
            this.purpose = authenticationRequest.getPurpose();
            this.requestObject = authenticationRequest.getRequestObject();
            this.requestURI = authenticationRequest.getRequestURI();
            this.rm = authenticationRequest.getResponseMode();
            this.codeChallenge = authenticationRequest.getCodeChallenge();
            this.codeChallengeMethod = authenticationRequest.getCodeChallengeMethod();
            this.authorizationDetails = authenticationRequest.getAuthorizationDetails();
            this.resources = authenticationRequest.getResources();
            this.includeGrantedScopes = authenticationRequest.includeGrantedScopes();
            this.customParams.putAll(authenticationRequest.getCustomParameters());
        }

        public Builder responseType(ResponseType responseType) {
            if (responseType == null) {
                throw new IllegalArgumentException("The response type must not be null");
            }
            this.rt = responseType;
            return this;
        }

        public Builder scope(Scope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("The scope must not be null");
            }
            if (!scope.contains(OIDCScopeValue.OPENID)) {
                throw new IllegalArgumentException("The scope must include an openid value");
            }
            this.scope = scope;
            return this;
        }

        public Builder redirectionURI(URI uRI) {
            if (uRI == null) {
                throw new IllegalArgumentException("The redirection URI must not be null");
            }
            this.redirectURI = uRI;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder endpointURI(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public Builder nonce(Nonce nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder display(Display display) {
            this.display = display;
            return this;
        }

        public Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder prompt(Prompt.Type ... typeArray) {
            if (typeArray.length == 1 && typeArray[0] == null) {
                return this.prompt((Prompt)null);
            }
            return this.prompt(new Prompt(typeArray));
        }

        public Builder dPoPJWKThumbprintConfirmation(JWKThumbprintConfirmation jWKThumbprintConfirmation) {
            this.dpopJKT = jWKThumbprintConfirmation;
            return this;
        }

        public Builder trustChain(TrustChain trustChain) {
            this.trustChain = trustChain;
            return this;
        }

        public Builder maxAge(int n2) {
            this.maxAge = n2;
            return this;
        }

        public Builder uiLocales(List<LangTag> list) {
            this.uiLocales = list;
            return this;
        }

        public Builder claimsLocales(List<LangTag> list) {
            this.claimsLocales = list;
            return this;
        }

        public Builder idTokenHint(JWT jWT) {
            this.idTokenHint = jWT;
            return this;
        }

        public Builder loginHint(String string) {
            this.loginHint = string;
            return this;
        }

        public Builder acrValues(List<ACR> list) {
            this.acrValues = list;
            return this;
        }

        @Deprecated
        public Builder claims(ClaimsRequest claimsRequest) {
            if (claimsRequest == null) {
                this.claims = null;
            } else {
                try {
                    this.claims = OIDCClaimsRequest.parse(claimsRequest.toJSONObject());
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException("Invalid claims: " + parseException.getMessage(), parseException);
                }
            }
            return this;
        }

        public Builder claims(OIDCClaimsRequest oIDCClaimsRequest) {
            this.claims = oIDCClaimsRequest;
            return this;
        }

        public Builder purpose(String string) {
            this.purpose = string;
            return this;
        }

        public Builder requestObject(JWT jWT) {
            this.requestObject = jWT;
            return this;
        }

        public Builder requestURI(URI uRI) {
            this.requestURI = uRI;
            return this;
        }

        public Builder responseMode(ResponseMode responseMode) {
            this.rm = responseMode;
            return this;
        }

        @Deprecated
        public Builder codeChallenge(CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod) {
            this.codeChallenge = codeChallenge;
            this.codeChallengeMethod = codeChallengeMethod;
            return this;
        }

        public Builder codeChallenge(CodeVerifier codeVerifier, CodeChallengeMethod codeChallengeMethod) {
            if (codeVerifier != null) {
                CodeChallengeMethod codeChallengeMethod2 = codeChallengeMethod != null ? codeChallengeMethod : CodeChallengeMethod.getDefault();
                this.codeChallenge = CodeChallenge.compute(codeChallengeMethod2, codeVerifier);
                this.codeChallengeMethod = codeChallengeMethod2;
            } else {
                this.codeChallenge = null;
                this.codeChallengeMethod = null;
            }
            return this;
        }

        public Builder authorizationDetails(List<AuthorizationDetail> list) {
            this.authorizationDetails = list;
            return this;
        }

        public Builder resource(URI uRI) {
            this.resources = uRI != null ? Collections.singletonList(uRI) : null;
            return this;
        }

        public Builder resources(URI ... uRIArray) {
            this.resources = uRIArray != null ? Arrays.asList(uRIArray) : null;
            return this;
        }

        public Builder includeGrantedScopes(boolean bl2) {
            this.includeGrantedScopes = bl2;
            return this;
        }

        public Builder customParameter(String string, String ... stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.customParams.remove(string);
            } else {
                this.customParams.put(string, Arrays.asList(stringArray));
            }
            return this;
        }

        public AuthenticationRequest build() {
            try {
                return new AuthenticationRequest(this.uri, this.rt, this.rm, this.scope, this.clientID, this.redirectURI, this.state, this.nonce, this.display, this.prompt, this.dpopJKT, this.trustChain, this.maxAge, this.uiLocales, this.claimsLocales, this.idTokenHint, this.loginHint, this.acrValues, this.claims, this.purpose, this.requestObject, this.requestURI, this.codeChallenge, this.codeChallengeMethod, this.authorizationDetails, this.resources, this.includeGrantedScopes, this.customParams);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

