/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;

public class DateWithTimeZoneOffset {
    private final Date date;
    private final int tzOffsetMinutes;
    private final boolean isUTC;

    public DateWithTimeZoneOffset(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        this.date = date;
        this.tzOffsetMinutes = 0;
        this.isUTC = true;
    }

    public DateWithTimeZoneOffset(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        this.date = date;
        if (n2 >= 720 || n2 <= -720) {
            throw new IllegalArgumentException("The time zone offset must be less than +/- 12 x 60 minutes");
        }
        this.tzOffsetMinutes = n2;
        this.isUTC = false;
    }

    public DateWithTimeZoneOffset(Date date, TimeZone timeZone) {
        this(date, timeZone.getOffset(date.getTime()) / 60000);
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isUTC() {
        return this.isUTC;
    }

    public int getTimeZoneOffsetMinutes() {
        return this.tzOffsetMinutes;
    }

    public String toISO8601String() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        simpleDateFormat.setTimeZone(timeZone);
        long l2 = DateUtils.toSecondsSinceEpoch(this.date);
        String string = simpleDateFormat.format(DateUtils.fromSecondsSinceEpoch(l2 += (long)this.tzOffsetMinutes * 60L));
        if (this.isUTC()) {
            return string + "Z";
        }
        int n2 = this.tzOffsetMinutes / 60;
        int n3 = this.tzOffsetMinutes - n2 * 60;
        if (this.tzOffsetMinutes == 0) {
            return string + "+00:00";
        }
        string = n2 > 0 ? string + "+" + (n2 < 10 ? "0" : "") + Math.abs(n2) : (n2 < 0 ? string + "-" + (n2 > -10 ? "0" : "") + Math.abs(n2) : (this.tzOffsetMinutes > 0 ? string + "+00" : string + "-00"));
        string = string + ":";
        string = n3 > 0 ? string + (n3 < 10 ? "0" : "") + n3 : (n3 < 0 ? string + (n3 > -10 ? "0" : "") + Math.abs(n3) : string + "00");
        return string;
    }

    public String toString() {
        return this.toISO8601String();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateWithTimeZoneOffset)) {
            return false;
        }
        DateWithTimeZoneOffset dateWithTimeZoneOffset = (DateWithTimeZoneOffset)object;
        return this.tzOffsetMinutes == dateWithTimeZoneOffset.tzOffsetMinutes && this.getDate().equals(dateWithTimeZoneOffset.getDate());
    }

    public int hashCode() {
        return Objects.hash(this.getDate(), this.tzOffsetMinutes);
    }

    public static DateWithTimeZoneOffset parseISO8601String(String string) throws ParseException {
        int n2;
        Date date;
        Matcher matcher;
        String string2 = string;
        if (Pattern.compile(".*[\\+\\-][\\d]{2}$").matcher(string).matches()) {
            string2 = string2 + ":00";
        }
        if ((matcher = Pattern.compile("(.*[\\+\\-][\\d]{2})(\\d{2})$").matcher(string2)).matches()) {
            string2 = matcher.group(1) + ":" + matcher.group(2);
        }
        if ((matcher = Pattern.compile("(.*\\d{2}:\\d{2}:\\d{2})([\\+\\-Z].*)$").matcher(string2)).matches()) {
            string2 = matcher.group(1) + ".000" + matcher.group(2);
        }
        int n3 = string2.length() - string2.replace(":", "").length();
        try {
            date = n3 == 1 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mmXXX").parse(string2) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(string2);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage());
        }
        if (string2.trim().endsWith("Z") || string2.trim().endsWith("z")) {
            return new DateWithTimeZoneOffset(date);
        }
        try {
            String string3 = string2.substring("2019-11-01T06:19:43.000".length());
            int n4 = Integer.parseInt(string3.substring(0, 3));
            int n5 = Integer.parseInt(string3.substring(4));
            n2 = string3.startsWith("+") ? n4 * 60 + n5 : n4 * 60 - n5;
        }
        catch (Exception exception) {
            throw new ParseException("Unexpected timezone offset: " + string);
        }
        return new DateWithTimeZoneOffset(date, n2);
    }
}

