/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.tokenexchange;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.Token;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TypelessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class TokenExchangeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.TOKEN_EXCHANGE;
    private final Token subjectToken;
    private final TokenTypeURI subjectTokenType;
    private final Token actorToken;
    private final TokenTypeURI actorTokenType;
    private final TokenTypeURI requestedTokenType;
    private final List<Audience> audience;

    public TokenExchangeGrant(Token token, TokenTypeURI tokenTypeURI) {
        this(token, tokenTypeURI, null, null, null, null);
    }

    public TokenExchangeGrant(Token token, TokenTypeURI tokenTypeURI, Token token2, TokenTypeURI tokenTypeURI2, TokenTypeURI tokenTypeURI3, List<Audience> list) {
        super(GRANT_TYPE);
        if (token == null) {
            throw new IllegalArgumentException("The subject token must not be null");
        }
        this.subjectToken = token;
        if (tokenTypeURI == null) {
            throw new IllegalArgumentException("The subject token type must not be null");
        }
        this.subjectTokenType = tokenTypeURI;
        this.actorToken = token2;
        if (token2 != null && tokenTypeURI2 == null) {
            throw new IllegalArgumentException("If an actor token is specified the actor token type must not be null");
        }
        this.actorTokenType = tokenTypeURI2;
        this.requestedTokenType = tokenTypeURI3;
        this.audience = list;
    }

    public Token getSubjectToken() {
        return this.subjectToken;
    }

    public TokenTypeURI getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public Token getActorToken() {
        return this.actorToken;
    }

    public TokenTypeURI getActorTokenType() {
        return this.actorTokenType;
    }

    public TokenTypeURI getRequestedTokenType() {
        return this.requestedTokenType;
    }

    public List<Audience> getAudience() {
        return this.audience;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        if (CollectionUtils.isNotEmpty(this.audience)) {
            linkedHashMap.put("audience", Audience.toStringList(this.audience));
        }
        if (this.requestedTokenType != null) {
            linkedHashMap.put("requested_token_type", Collections.singletonList(this.requestedTokenType.getURI().toString()));
        }
        linkedHashMap.put("subject_token", Collections.singletonList(this.subjectToken.getValue()));
        linkedHashMap.put("subject_token_type", Collections.singletonList(this.subjectTokenType.getURI().toString()));
        if (this.actorToken != null) {
            linkedHashMap.put("actor_token", Collections.singletonList(this.actorToken.getValue()));
            linkedHashMap.put("actor_token_type", Collections.singletonList(this.actorTokenType.getURI().toString()));
        }
        return linkedHashMap;
    }

    private static List<Audience> parseAudience(Map<String, List<String>> map) {
        List<String> list = map.get("audience");
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return Audience.create(list);
    }

    private static TokenTypeURI parseTokenType(Map<String, List<String>> map, String string, boolean bl2) throws ParseException {
        String string2 = MultivaluedMapUtils.getFirstValue(map, string);
        if (StringUtils.isBlank(string2)) {
            if (bl2) {
                String string3 = String.format("Missing or empty %s parameter", string);
                throw new ParseException(string3, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string3));
            }
            return null;
        }
        try {
            return TokenTypeURI.parse(string2);
        }
        catch (ParseException parseException) {
            String string4 = "Invalid " + string + " " + string2;
            throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4));
        }
    }

    private static TypelessToken parseToken(Map<String, List<String>> map, String string, boolean bl2) throws ParseException {
        String string2 = MultivaluedMapUtils.getFirstValue(map, string);
        if (StringUtils.isBlank(string2)) {
            if (bl2) {
                String string3 = String.format("Missing or empty %s parameter", string);
                throw new ParseException(string3, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string3));
            }
            return null;
        }
        return new TypelessToken(string2);
    }

    public static TokenExchangeGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        List<Audience> list = TokenExchangeGrant.parseAudience(map);
        TokenTypeURI tokenTypeURI = TokenExchangeGrant.parseTokenType(map, "requested_token_type", false);
        TypelessToken typelessToken = TokenExchangeGrant.parseToken(map, "subject_token", true);
        TokenTypeURI tokenTypeURI2 = TokenExchangeGrant.parseTokenType(map, "subject_token_type", true);
        TypelessToken typelessToken2 = TokenExchangeGrant.parseToken(map, "actor_token", false);
        TokenTypeURI tokenTypeURI3 = TokenExchangeGrant.parseTokenType(map, "actor_token_type", false);
        return new TokenExchangeGrant(typelessToken, tokenTypeURI2, typelessToken2, tokenTypeURI3, tokenTypeURI, list);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TokenExchangeGrant)) {
            return false;
        }
        TokenExchangeGrant tokenExchangeGrant = (TokenExchangeGrant)object;
        return this.getSubjectToken().equals(tokenExchangeGrant.getSubjectToken()) && this.getSubjectTokenType().equals(tokenExchangeGrant.getSubjectTokenType()) && Objects.equals(this.getActorToken(), tokenExchangeGrant.getActorToken()) && Objects.equals(this.getActorTokenType(), tokenExchangeGrant.getActorTokenType()) && Objects.equals(this.getRequestedTokenType(), tokenExchangeGrant.getRequestedTokenType()) && Objects.equals(this.getAudience(), tokenExchangeGrant.getAudience());
    }

    public int hashCode() {
        return Objects.hash(this.getSubjectToken(), this.getSubjectTokenType(), this.getActorToken(), this.getActorTokenType(), this.getRequestedTokenType(), this.getAudience());
    }
}

