/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Nonce;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@ThreadSafe
public class HTTPResponse
extends HTTPMessage
implements ReadOnlyHTTPResponse {
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_FOUND = 302;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_SERVER_ERROR = 500;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    private final int statusCode;
    private String statusMessage;

    public HTTPResponse(int n2) {
        this.statusCode = n2;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean indicatesSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public void ensureStatusCode(int ... nArray) throws ParseException {
        for (int n2 : nArray) {
            if (this.statusCode != n2) continue;
            return;
        }
        throw new ParseException("Unexpected HTTP status code " + this.statusCode + ", must be " + Arrays.toString(nArray));
    }

    public void ensureStatusCodeNotOK() throws ParseException {
        if (this.statusCode == 200) {
            throw new ParseException("Unexpected HTTP status code, must not be 200 (OK)");
        }
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String string) {
        this.statusMessage = string;
    }

    public URI getLocation() {
        String string = this.getHeaderValue("Location");
        if (string == null) {
            return null;
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public void setLocation(URI uRI) {
        this.setHeader("Location", new String[]{uRI != null ? uRI.toString() : null});
    }

    public String getCacheControl() {
        return this.getHeaderValue("Cache-Control");
    }

    public void setCacheControl(String string) {
        this.setHeader("Cache-Control", new String[]{string});
    }

    public String getPragma() {
        return this.getHeaderValue("Pragma");
    }

    public void setPragma(String string) {
        this.setHeader("Pragma", new String[]{string});
    }

    public String getWWWAuthenticate() {
        return this.getHeaderValue("WWW-Authenticate");
    }

    public void setWWWAuthenticate(String string) {
        this.setHeader("WWW-Authenticate", new String[]{string});
    }

    public Nonce getDPoPNonce() {
        String string = this.getHeaderValue("DPoP-Nonce");
        if (string == null) {
            return null;
        }
        try {
            return new Nonce(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public void setDPoPNonce(Nonce nonce) {
        if (nonce != null) {
            this.setHeader("DPoP-Nonce", new String[]{nonce.getValue()});
        } else {
            this.setHeader("DPoP-Nonce", null);
        }
    }

    @Deprecated
    public String getContent() {
        return this.getBody();
    }

    @Deprecated
    public JSONObject getContentAsJSONObject() throws ParseException {
        return this.getBodyAsJSONObject();
    }

    @Deprecated
    public JSONArray getContentAsJSONArray() throws ParseException {
        return this.getBodyAsJSONArray();
    }

    @Deprecated
    public JWT getContentAsJWT() throws ParseException {
        return this.getBodyAsJWT();
    }

    @Deprecated
    public void setContent(String string) {
        this.setBody(string);
    }
}

