/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequestSender;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@ThreadSafe
public class HTTPRequest
extends HTTPMessage
implements ReadOnlyHTTPRequest {
    private final Method method;
    private URL url;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private Proxy proxy = null;
    private boolean followRedirects = true;
    private X509Certificate clientX509Certificate = null;
    private String clientX509CertificateSubjectDN = null;
    private String clientX509CertificateRootDN = null;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    private static HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    private static SSLSocketFactory defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private boolean debugCloseStreams = false;

    public HTTPRequest(Method method, URL uRL) {
        if (method == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.method = method;
        if (uRL == null) {
            throw new IllegalArgumentException("The HTTP URL must not be null");
        }
        this.url = uRL;
    }

    public HTTPRequest(Method method, URI uRI) {
        this(method, HTTPRequest.toURLWithUncheckedException(uRI));
    }

    private static URL toURLWithUncheckedException(URI uRI) {
        try {
            return uRI.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            throw new SerializeException(exception.getMessage(), exception);
        }
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public void ensureMethod(Method method) throws ParseException {
        if (this.method != method) {
            throw new ParseException("The HTTP request method must be " + (Object)((Object)method));
        }
    }

    public String getAuthorization() {
        return this.getHeaderValue("Authorization");
    }

    public void setAuthorization(String string) {
        this.setHeader("Authorization", new String[]{string});
    }

    public SignedJWT getDPoP() {
        try {
            return this.getPoPWithException();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public SignedJWT getPoPWithException() throws ParseException {
        String string = this.getHeaderValue("DPoP");
        if (string == null) {
            return null;
        }
        try {
            return SignedJWT.parse(string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
    }

    public void setDPoP(SignedJWT signedJWT) {
        if (signedJWT != null) {
            this.setHeader("DPoP", new String[]{signedJWT.serialize()});
        } else {
            this.setHeader("DPoP", null);
        }
    }

    public String getAccept() {
        return this.getHeaderValue("Accept");
    }

    public void setAccept(String string) {
        this.setHeader("Accept", new String[]{string});
    }

    void setDebugCloseStreams(boolean bl2) {
        this.debugCloseStreams = bl2;
    }

    public void appendQueryParameters(Map<String, List<String>> map) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        this.appendQueryString(URLUtils.serializeParameters(map));
    }

    public void appendQueryString(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (StringUtils.isNotBlank(string) && string.startsWith("?")) {
            throw new IllegalArgumentException("The query string must not start with ?");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(this.url.getQuery())) {
            stringBuilder.append(this.url.getQuery());
            stringBuilder.append('&');
        }
        stringBuilder.append(string);
        this.url = URLUtils.setEncodedQuery(this.url, stringBuilder.toString());
    }

    @Deprecated
    public String getQuery() {
        return Method.POST.equals((Object)this.getMethod()) ? this.getBody() : this.getURL().getQuery();
    }

    @Deprecated
    public void setQuery(String string) {
        if (Method.POST.equals((Object)this.getMethod())) {
            this.setBody(string);
        } else {
            this.appendQueryString(string);
        }
    }

    private void ensureQuery() throws ParseException {
        if (this.getQuery() == null || this.getQuery().trim().isEmpty()) {
            throw new ParseException("Missing or empty HTTP query string / entity body");
        }
    }

    public Map<String, List<String>> getQueryStringParameters() {
        return URLUtils.parseParameters(this.url.getQuery());
    }

    @Deprecated
    public Map<String, List<String>> getQueryParameters() {
        return URLUtils.parseParameters(this.getQuery());
    }

    @Deprecated
    public JSONObject getQueryAsJSONObject() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JSON);
        this.ensureQuery();
        return JSONObjectUtils.parse(this.getQuery());
    }

    @Deprecated
    public String getFragment() {
        return this.url.getRef();
    }

    public void setFragment(String string) {
        this.url = URLUtils.setEncodedFragment(this.url, string);
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The HTTP connect timeout must be zero or positive");
        }
        this.connectTimeout = n2;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The HTTP response read timeout must be zero or positive");
        }
        this.readTimeout = n2;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean bl2) {
        this.followRedirects = bl2;
    }

    public X509Certificate getClientX509Certificate() {
        return this.clientX509Certificate;
    }

    public void setClientX509Certificate(X509Certificate x509Certificate) {
        this.clientX509Certificate = x509Certificate;
    }

    public String getClientX509CertificateSubjectDN() {
        return this.clientX509CertificateSubjectDN;
    }

    public void setClientX509CertificateSubjectDN(String string) {
        this.clientX509CertificateSubjectDN = string;
    }

    public String getClientX509CertificateRootDN() {
        return this.clientX509CertificateRootDN;
    }

    public void setClientX509CertificateRootDN(String string) {
        this.clientX509CertificateRootDN = string;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("The hostname verifier must not be null");
        }
        defaultHostnameVerifier = hostnameVerifier;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLSocketFactory;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new IllegalArgumentException("The SSL socket factory must not be null");
        }
        defaultSSLSocketFactory = sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HttpURLConnection toHttpURLConnection(HostnameVerifier hostnameVerifier, SSLSocketFactory sSLSocketFactory) throws IOException {
        HostnameVerifier hostnameVerifier2 = this.getHostnameVerifier();
        SSLSocketFactory sSLSocketFactory2 = this.getSSLSocketFactory();
        try {
            this.setHostnameVerifier(hostnameVerifier);
            this.setSSLSocketFactory(sSLSocketFactory);
            HttpURLConnection httpURLConnection = this.toHttpURLConnection();
            return httpURLConnection;
        }
        finally {
            this.setHostnameVerifier(hostnameVerifier2);
            this.setSSLSocketFactory(sSLSocketFactory2);
        }
    }

    public HttpURLConnection toHttpURLConnection() throws IOException {
        Object object;
        URL uRL = this.getURL();
        HttpURLConnection httpURLConnection = (HttpURLConnection)(this.proxy == null ? uRL.openConnection() : uRL.openConnection(this.proxy));
        if (httpURLConnection instanceof HttpsURLConnection) {
            object = (HttpsURLConnection)httpURLConnection;
            ((HttpsURLConnection)object).setHostnameVerifier(this.hostnameVerifier != null ? this.hostnameVerifier : HTTPRequest.getDefaultHostnameVerifier());
            ((HttpsURLConnection)object).setSSLSocketFactory(this.sslSocketFactory != null ? this.sslSocketFactory : HTTPRequest.getDefaultSSLSocketFactory());
        }
        for (Map.Entry object2 : this.getHeaderMap().entrySet()) {
            for (String string : (List)object2.getValue()) {
                httpURLConnection.addRequestProperty((String)object2.getKey(), string);
            }
        }
        httpURLConnection.setRequestMethod(this.method.name());
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        httpURLConnection.setInstanceFollowRedirects(this.followRedirects);
        if (this.method.equals((Object)Method.POST) || this.method.equals((Object)Method.PUT)) {
            httpURLConnection.setDoOutput(true);
            if (this.getEntityContentType() != null) {
                httpURLConnection.setRequestProperty("Content-Type", this.getEntityContentType().toString());
            }
            if (this.getBody() != null) {
                object = null;
                try {
                    object = httpURLConnection.getOutputStream();
                    OutputStreamWriter iOException = new OutputStreamWriter((OutputStream)object);
                    iOException.write(this.getBody());
                    iOException.close();
                }
                catch (IOException iOException) {
                    HTTPRequest.closeStreams(httpURLConnection.getInputStream(), (OutputStream)object, httpURLConnection.getErrorStream(), this.debugCloseStreams);
                    throw iOException;
                }
            }
        }
        return httpURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HTTPResponse send(HostnameVerifier hostnameVerifier, SSLSocketFactory sSLSocketFactory) throws IOException {
        HostnameVerifier hostnameVerifier2 = this.getHostnameVerifier();
        SSLSocketFactory sSLSocketFactory2 = this.getSSLSocketFactory();
        try {
            this.setHostnameVerifier(hostnameVerifier);
            this.setSSLSocketFactory(sSLSocketFactory);
            HTTPResponse hTTPResponse = this.send();
            return hTTPResponse;
        }
        finally {
            this.setHostnameVerifier(hostnameVerifier2);
            this.setSSLSocketFactory(sSLSocketFactory2);
        }
    }

    public HTTPResponse send() throws IOException {
        String string;
        int n2;
        BufferedReader bufferedReader;
        HttpURLConnection httpURLConnection = this.toHttpURLConnection();
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        try {
            if (httpURLConnection.getDoOutput()) {
                outputStream = httpURLConnection.getOutputStream();
            }
            inputStream = httpURLConnection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            n2 = httpURLConnection.getResponseCode();
        }
        catch (IOException iOException) {
            n2 = httpURLConnection.getResponseCode();
            if (n2 == -1) {
                throw iOException;
            }
            inputStream2 = httpURLConnection.getErrorStream();
            bufferedReader = inputStream2 != null ? new BufferedReader(new InputStreamReader(inputStream2, StandardCharsets.UTF_8)) : new BufferedReader(new StringReader(""));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append(System.getProperty("line.separator"));
        }
        bufferedReader.close();
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        hTTPResponse.setStatusMessage(httpURLConnection.getResponseMessage());
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            List<String> list;
            if (entry.getKey() == null || (list = entry.getValue()) == null || list.isEmpty() || list.get(0) == null) continue;
            hTTPResponse.setHeader(entry.getKey(), list.toArray(new String[0]));
        }
        HTTPRequest.closeStreams(inputStream, outputStream, inputStream2, this.debugCloseStreams);
        String string2 = stringBuilder.toString();
        if (!string2.isEmpty()) {
            hTTPResponse.setBody(string2);
        }
        return hTTPResponse;
    }

    public HTTPResponse send(HTTPRequestSender hTTPRequestSender) throws IOException {
        ReadOnlyHTTPResponse readOnlyHTTPResponse = hTTPRequestSender.send(this);
        HTTPResponse hTTPResponse = new HTTPResponse(readOnlyHTTPResponse.getStatusCode());
        hTTPResponse.setStatusMessage(readOnlyHTTPResponse.getStatusMessage());
        for (Map.Entry<String, List<String>> entry : readOnlyHTTPResponse.getHeaderMap().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            hTTPResponse.setHeader(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        hTTPResponse.setBody(readOnlyHTTPResponse.getBody());
        return hTTPResponse;
    }

    private static void closeStreams(InputStream inputStream, OutputStream outputStream, InputStream inputStream2, boolean bl2) throws IOException {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            if (bl2) {
                throw iOException;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            if (bl2) {
                throw iOException;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (IOException iOException) {
            if (bl2) {
                throw iOException;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

