/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ContentTypeUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

abstract class HTTPMessage
implements ReadOnlyHTTPMessage {
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private String body;
    private String clientIPAddress;

    HTTPMessage() {
    }

    public ContentType getEntityContentType() {
        String string = this.getHeaderValue("Content-Type");
        if (string == null) {
            return null;
        }
        try {
            return ContentType.parse(string);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public void setEntityContentType(ContentType contentType) {
        this.setHeader("Content-Type", contentType != null ? contentType.toString() : null);
    }

    public void setContentType(String string) throws ParseException {
        try {
            this.setHeader("Content-Type", string != null ? ContentType.parse(string).toString() : null);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid Content-Type value: " + parseException.getMessage());
        }
    }

    public void ensureEntityContentType() throws ParseException {
        if (this.getEntityContentType() == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
    }

    public void ensureEntityContentType(ContentType contentType) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, this.getEntityContentType());
    }

    public void ensureEntityContentType(ContentType contentType, String string) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, string, this.getEntityContentType());
    }

    public String getHeaderValue(String string) {
        return MultivaluedMapUtils.getFirstValue(this.headers, string);
    }

    public List<String> getHeaderValues(String string) {
        return this.headers.get(string);
    }

    public void setHeader(String string, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.headers.put(string, Arrays.asList(stringArray));
        } else {
            this.headers.remove(string);
        }
    }

    @Override
    public Map<String, List<String>> getHeaderMap() {
        return this.headers;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    private void ensureBody() throws ParseException {
        if (this.getBody() == null || this.getBody().isEmpty()) {
            throw new ParseException("Missing or empty HTTP message body");
        }
    }

    public Map<String, List<String>> getBodyAsFormParameters() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        if (StringUtils.isBlank(this.getBody())) {
            return Collections.emptyMap();
        }
        return URLUtils.parseParameters(this.getBody());
    }

    public JSONObject getBodyAsJSONObject() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JSON, "json");
        this.ensureBody();
        return JSONObjectUtils.parse(this.getBody());
    }

    public JSONArray getBodyAsJSONArray() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JSON, "json");
        this.ensureBody();
        return JSONArrayUtils.parse(this.getBody());
    }

    public JWT getBodyAsJWT() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JWT, "jwt");
        this.ensureBody();
        try {
            return JWTParser.parse(this.getBody());
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String string) {
        this.clientIPAddress = string;
    }
}

