/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class ClientReadRequest
extends ProtectedResourceRequest {
    public ClientReadRequest(URI uRI, BearerAccessToken bearerAccessToken) {
        super(uRI, bearerAccessToken);
        if (bearerAccessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, this.getEndpointURI());
        hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        return hTTPRequest;
    }

    public static ClientReadRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        return new ClientReadRequest(hTTPRequest.getURI(), BearerAccessToken.parse(hTTPRequest.getAuthorization()));
    }
}

