/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientInformation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class ClientInformationResponse
extends ClientRegistrationResponse
implements SuccessResponse {
    private final ClientInformation clientInfo;
    private final boolean forNewClient;

    public ClientInformationResponse(ClientInformation clientInformation, boolean bl2) {
        if (clientInformation == null) {
            throw new IllegalArgumentException("The client information must not be null");
        }
        this.clientInfo = clientInformation;
        this.forNewClient = bl2;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public ClientInformation getClientInformation() {
        return this.clientInfo;
    }

    public boolean isForNewClient() {
        return this.forNewClient;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(this.forNewClient ? 201 : 200);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.clientInfo.toJSONObject().toString());
        return hTTPResponse;
    }

    public static ClientInformationResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200, 201);
        ClientInformation clientInformation = ClientInformation.parse(hTTPResponse.getContentAsJSONObject());
        boolean bl2 = 201 == hTTPResponse.getStatusCode();
        return new ClientInformationResponse(clientInformation, bl2);
    }
}

