/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientCredentialsParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class ClientInformation {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final ClientID id;
    private final Date issueDate;
    private final ClientMetadata metadata;
    private final Secret secret;
    private final URI registrationURI;
    private final BearerAccessToken accessToken;

    public ClientInformation(ClientID clientID, ClientMetadata clientMetadata) {
        this(clientID, null, clientMetadata, null);
    }

    public ClientInformation(ClientID clientID, Date date, ClientMetadata clientMetadata, Secret secret) {
        this(clientID, date, clientMetadata, secret, null, null);
    }

    public ClientInformation(ClientID clientID, Date date, ClientMetadata clientMetadata, Secret secret, URI uRI, BearerAccessToken bearerAccessToken) {
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = clientID;
        this.issueDate = date;
        if (clientMetadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = clientMetadata;
        this.secret = secret;
        this.registrationURI = uRI;
        this.accessToken = bearerAccessToken;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ClientID getID() {
        return this.id;
    }

    public Date getIDIssueDate() {
        return this.issueDate;
    }

    public ClientMetadata getMetadata() {
        return this.metadata;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public ClientType inferClientType() {
        return this.secret == null && ClientAuthenticationMethod.NONE.equals(this.getMetadata().getTokenEndpointAuthMethod()) && this.getMetadata().getJWKSetURI() == null && this.getMetadata().getJWKSet() == null ? ClientType.PUBLIC : ClientType.CONFIDENTIAL;
    }

    public URI getRegistrationURI() {
        return this.registrationURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = this.metadata.toJSONObject();
        jSONObject.put("client_id", this.id.getValue());
        if (this.issueDate != null) {
            jSONObject.put("client_id_issued_at", this.issueDate.getTime() / 1000L);
        }
        if (this.secret != null) {
            jSONObject.put("client_secret", this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                jSONObject.put("client_secret_expires_at", this.secret.getExpirationDate().getTime() / 1000L);
            } else {
                jSONObject.put("client_secret_expires_at", 0L);
            }
        }
        if (this.registrationURI != null) {
            jSONObject.put("registration_client_uri", this.registrationURI.toString());
        }
        if (this.accessToken != null) {
            jSONObject.put("registration_access_token", this.accessToken.getValue());
        }
        return jSONObject;
    }

    public static ClientInformation parse(JSONObject jSONObject) throws ParseException {
        return new ClientInformation(ClientCredentialsParser.parseID(jSONObject), ClientCredentialsParser.parseIDIssueDate(jSONObject), ClientMetadata.parse(jSONObject), ClientCredentialsParser.parseSecret(jSONObject), ClientCredentialsParser.parseRegistrationURI(jSONObject), ClientCredentialsParser.parseRegistrationAccessToken(jSONObject));
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        hashSet.add("client_id");
        hashSet.add("client_id_issued_at");
        hashSet.add("client_secret");
        hashSet.add("client_secret_expires_at");
        hashSet.add("registration_access_token");
        hashSet.add("registration_client_uri");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

