/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client;

import java.net.URI;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ClientCredentialsParser {
    public static ClientID parseID(JSONObject jSONObject) throws ParseException {
        return new ClientID(JSONObjectUtils.getString(jSONObject, "client_id"));
    }

    public static Date parseIDIssueDate(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey("client_id_issued_at")) {
            return new Date(JSONObjectUtils.getLong(jSONObject, "client_id_issued_at") * 1000L);
        }
        return null;
    }

    public static Secret parseSecret(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey("client_secret")) {
            long l2;
            String string = JSONObjectUtils.getString(jSONObject, "client_secret");
            Date date = null;
            if (jSONObject.containsKey("client_secret_expires_at") && (l2 = JSONObjectUtils.getLong(jSONObject, "client_secret_expires_at")) > 0L) {
                date = new Date(l2 * 1000L);
            }
            return new Secret(string, date);
        }
        return null;
    }

    public static URI parseRegistrationURI(JSONObject jSONObject) throws ParseException {
        return JSONObjectUtils.getURI(jSONObject, "registration_client_uri", null);
    }

    public static BearerAccessToken parseRegistrationAccessToken(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey("registration_access_token")) {
            return new BearerAccessToken(JSONObjectUtils.getString(jSONObject, "registration_access_token"));
        }
        return null;
    }
}

