/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.MACVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PKITLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.SelfSignedTLSClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.ClientCredentialsSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.ClientX509CertificateBindingVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.Context;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.ExpendedJTIChecker;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.Hint;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.InvalidClientException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.JWTAuthenticationClaimsSetVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.verifier.PKIClientX509CertificateBindingVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ListUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.X509CertificateUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ClientAuthenticationVerifier<T> {
    private final ClientCredentialsSelector<T> clientCredentialsSelector;
    @Deprecated
    private final ClientX509CertificateBindingVerifier<T> certBindingVerifier;
    private final PKIClientX509CertificateBindingVerifier<T> pkiCertBindingVerifier;
    private final JWTAuthenticationClaimsSetVerifier claimsSetVerifier;
    private final ExpendedJTIChecker<T> expendedJTIChecker;
    private final JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();

    @Deprecated
    public ClientAuthenticationVerifier(ClientCredentialsSelector<T> clientCredentialsSelector, ClientX509CertificateBindingVerifier<T> clientX509CertificateBindingVerifier, Set<Audience> set) {
        this.claimsSetVerifier = new JWTAuthenticationClaimsSetVerifier(set);
        if (clientCredentialsSelector == null) {
            throw new IllegalArgumentException("The client credentials selector must not be null");
        }
        this.certBindingVerifier = clientX509CertificateBindingVerifier;
        this.pkiCertBindingVerifier = null;
        this.clientCredentialsSelector = clientCredentialsSelector;
        this.expendedJTIChecker = null;
    }

    public ClientAuthenticationVerifier(ClientCredentialsSelector<T> clientCredentialsSelector, Set<Audience> set) {
        this(clientCredentialsSelector, set, null);
    }

    public ClientAuthenticationVerifier(ClientCredentialsSelector<T> clientCredentialsSelector, Set<Audience> set, ExpendedJTIChecker<T> expendedJTIChecker) {
        this.claimsSetVerifier = new JWTAuthenticationClaimsSetVerifier(set);
        if (clientCredentialsSelector == null) {
            throw new IllegalArgumentException("The client credentials selector must not be null");
        }
        this.certBindingVerifier = null;
        this.pkiCertBindingVerifier = null;
        this.clientCredentialsSelector = clientCredentialsSelector;
        this.expendedJTIChecker = expendedJTIChecker;
    }

    public ClientAuthenticationVerifier(ClientCredentialsSelector<T> clientCredentialsSelector, PKIClientX509CertificateBindingVerifier<T> pKIClientX509CertificateBindingVerifier, Set<Audience> set) {
        this(clientCredentialsSelector, pKIClientX509CertificateBindingVerifier, set, null, -1L);
    }

    public ClientAuthenticationVerifier(ClientCredentialsSelector<T> clientCredentialsSelector, PKIClientX509CertificateBindingVerifier<T> pKIClientX509CertificateBindingVerifier, Set<Audience> set, ExpendedJTIChecker<T> expendedJTIChecker, long l2) {
        this.claimsSetVerifier = new JWTAuthenticationClaimsSetVerifier(set, l2);
        if (clientCredentialsSelector == null) {
            throw new IllegalArgumentException("The client credentials selector must not be null");
        }
        this.certBindingVerifier = null;
        this.pkiCertBindingVerifier = pKIClientX509CertificateBindingVerifier;
        this.clientCredentialsSelector = clientCredentialsSelector;
        this.expendedJTIChecker = expendedJTIChecker;
    }

    public ClientCredentialsSelector<T> getClientCredentialsSelector() {
        return this.clientCredentialsSelector;
    }

    @Deprecated
    public ClientX509CertificateBindingVerifier<T> getClientX509CertificateBindingVerifier() {
        return this.certBindingVerifier;
    }

    public PKIClientX509CertificateBindingVerifier<T> getPKIClientX509CertificateBindingVerifier() {
        return this.pkiCertBindingVerifier;
    }

    public Set<Audience> getExpectedAudience() {
        return this.claimsSetVerifier.getExpectedAudience();
    }

    public ExpendedJTIChecker<T> getExpendedJTIChecker() {
        return this.expendedJTIChecker;
    }

    private static List<Secret> removeNullOrErased(List<Secret> list) {
        List<Secret> list2 = ListUtils.removeNullItems(list);
        if (list2 == null) {
            return null;
        }
        LinkedList<Secret> linkedList = new LinkedList<Secret>();
        for (Secret secret : list) {
            if (secret.getValue() == null || secret.getValueBytes() == null) continue;
            linkedList.add(secret);
        }
        return linkedList;
    }

    private void preventJWTReplay(JWTID jWTID, ClientID clientID, ClientAuthenticationMethod clientAuthenticationMethod, Context<T> context) throws InvalidClientException {
        if (jWTID == null || this.getExpendedJTIChecker() == null) {
            return;
        }
        if (this.getExpendedJTIChecker().isExpended(jWTID, clientID, clientAuthenticationMethod, context)) {
            throw new InvalidClientException("Detected JWT ID replay");
        }
    }

    private void markExpended(JWTID jWTID, Date date, ClientID clientID, ClientAuthenticationMethod clientAuthenticationMethod, Context<T> context) {
        if (jWTID == null || this.getExpendedJTIChecker() == null) {
            return;
        }
        this.getExpendedJTIChecker().markExpended(jWTID, date, clientID, clientAuthenticationMethod, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verify(ClientAuthentication clientAuthentication, Set<Hint> set, Context<T> context) throws InvalidClientException, JOSEException {
        if (clientAuthentication instanceof PlainClientSecret) {
            List<Secret> list = ListUtils.removeNullItems(this.clientCredentialsSelector.selectClientSecrets(clientAuthentication.getClientID(), clientAuthentication.getMethod(), context));
            if (CollectionUtils.isEmpty(list)) {
                throw InvalidClientException.NO_REGISTERED_SECRET;
            }
            PlainClientSecret plainClientSecret = (PlainClientSecret)clientAuthentication;
            for (Secret secret : list) {
                if (!secret.equals(plainClientSecret.getClientSecret())) continue;
                return;
            }
            throw InvalidClientException.BAD_SECRET;
        }
        if (clientAuthentication instanceof ClientSecretJWT) {
            ClientSecretJWT clientSecretJWT = (ClientSecretJWT)clientAuthentication;
            JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet = clientSecretJWT.getJWTAuthenticationClaimsSet();
            this.preventJWTReplay(jWTAuthenticationClaimsSet.getJWTID(), clientAuthentication.getClientID(), ClientAuthenticationMethod.CLIENT_SECRET_JWT, context);
            try {
                this.claimsSetVerifier.verify(jWTAuthenticationClaimsSet.toJWTClaimsSet(), null);
            }
            catch (BadJWTException badJWTException) {
                throw new InvalidClientException("Bad / expired JWT claims: " + badJWTException.getMessage());
            }
            List<Secret> list = ClientAuthenticationVerifier.removeNullOrErased(this.clientCredentialsSelector.selectClientSecrets(clientAuthentication.getClientID(), clientAuthentication.getMethod(), context));
            if (CollectionUtils.isEmpty(list)) {
                throw InvalidClientException.NO_REGISTERED_SECRET;
            }
            SignedJWT signedJWT = clientSecretJWT.getClientAssertion();
            for (Secret secret : list) {
                boolean bl2 = signedJWT.verify(new MACVerifier(secret.getValueBytes()));
                if (!bl2) continue;
                this.markExpended(jWTAuthenticationClaimsSet.getJWTID(), jWTAuthenticationClaimsSet.getExpirationTime(), clientAuthentication.getClientID(), ClientAuthenticationMethod.CLIENT_SECRET_JWT, context);
                return;
            }
            throw InvalidClientException.BAD_JWT_HMAC;
        }
        if (clientAuthentication instanceof PrivateKeyJWT) {
            boolean bl3;
            JWSVerifier jWSVerifier;
            PrivateKeyJWT privateKeyJWT = (PrivateKeyJWT)clientAuthentication;
            JWTAuthenticationClaimsSet jWTAuthenticationClaimsSet = privateKeyJWT.getJWTAuthenticationClaimsSet();
            this.preventJWTReplay(jWTAuthenticationClaimsSet.getJWTID(), clientAuthentication.getClientID(), ClientAuthenticationMethod.PRIVATE_KEY_JWT, context);
            try {
                this.claimsSetVerifier.verify(jWTAuthenticationClaimsSet.toJWTClaimsSet(), null);
            }
            catch (BadJWTException badJWTException) {
                throw new InvalidClientException("Bad / expired JWT claims: " + badJWTException.getMessage());
            }
            List<PublicKey> list = ListUtils.removeNullItems(this.clientCredentialsSelector.selectPublicKeys(privateKeyJWT.getClientID(), privateKeyJWT.getMethod(), privateKeyJWT.getClientAssertion().getHeader(), false, context));
            if (CollectionUtils.isEmpty(list)) {
                throw InvalidClientException.NO_MATCHING_JWK;
            }
            SignedJWT signedJWT = privateKeyJWT.getClientAssertion();
            for (PublicKey publicKey : list) {
                jWSVerifier = this.jwsVerifierFactory.createJWSVerifier(privateKeyJWT.getClientAssertion().getHeader(), publicKey);
                bl3 = signedJWT.verify(jWSVerifier);
                if (!bl3) continue;
                this.markExpended(jWTAuthenticationClaimsSet.getJWTID(), jWTAuthenticationClaimsSet.getExpirationTime(), clientAuthentication.getClientID(), ClientAuthenticationMethod.PRIVATE_KEY_JWT, context);
                return;
            }
            if (set == null || !set.contains((Object)Hint.CLIENT_HAS_REMOTE_JWK_SET)) throw InvalidClientException.BAD_JWT_SIGNATURE;
            list = ListUtils.removeNullItems(this.clientCredentialsSelector.selectPublicKeys(privateKeyJWT.getClientID(), privateKeyJWT.getMethod(), privateKeyJWT.getClientAssertion().getHeader(), true, context));
            if (CollectionUtils.isEmpty(list)) {
                throw InvalidClientException.NO_MATCHING_JWK;
            }
            signedJWT = privateKeyJWT.getClientAssertion();
            for (PublicKey publicKey : list) {
                jWSVerifier = this.jwsVerifierFactory.createJWSVerifier(privateKeyJWT.getClientAssertion().getHeader(), publicKey);
                bl3 = signedJWT.verify(jWSVerifier);
                if (!bl3) continue;
                this.markExpended(jWTAuthenticationClaimsSet.getJWTID(), jWTAuthenticationClaimsSet.getExpirationTime(), clientAuthentication.getClientID(), ClientAuthenticationMethod.PRIVATE_KEY_JWT, context);
                return;
            }
            throw InvalidClientException.BAD_JWT_SIGNATURE;
        }
        if (clientAuthentication instanceof SelfSignedTLSClientAuthentication) {
            boolean bl4;
            SelfSignedTLSClientAuthentication selfSignedTLSClientAuthentication = (SelfSignedTLSClientAuthentication)clientAuthentication;
            X509Certificate x509Certificate = selfSignedTLSClientAuthentication.getClientX509Certificate();
            if (x509Certificate == null) {
                throw new InvalidClientException("Missing client X.509 certificate");
            }
            List<PublicKey> list = ListUtils.removeNullItems(this.clientCredentialsSelector.selectPublicKeys(selfSignedTLSClientAuthentication.getClientID(), selfSignedTLSClientAuthentication.getMethod(), null, false, context));
            if (CollectionUtils.isEmpty(list)) {
                throw InvalidClientException.NO_MATCHING_JWK;
            }
            for (PublicKey publicKey : list) {
                bl4 = X509CertificateUtils.publicKeyMatches(x509Certificate, publicKey);
                if (!bl4) continue;
                return;
            }
            if (set == null || !set.contains((Object)Hint.CLIENT_HAS_REMOTE_JWK_SET)) throw InvalidClientException.BAD_SELF_SIGNED_CLIENT_CERTIFICATE;
            list = ListUtils.removeNullItems(this.clientCredentialsSelector.selectPublicKeys(selfSignedTLSClientAuthentication.getClientID(), selfSignedTLSClientAuthentication.getMethod(), null, true, context));
            if (CollectionUtils.isEmpty(list)) {
                throw InvalidClientException.NO_MATCHING_JWK;
            }
            for (PublicKey publicKey : list) {
                if (publicKey == null || !(bl4 = X509CertificateUtils.publicKeyMatches(x509Certificate, publicKey))) continue;
                return;
            }
            throw InvalidClientException.BAD_SELF_SIGNED_CLIENT_CERTIFICATE;
        }
        if (!(clientAuthentication instanceof PKITLSClientAuthentication)) throw new RuntimeException("Unexpected client authentication: " + clientAuthentication.getMethod());
        PKITLSClientAuthentication pKITLSClientAuthentication = (PKITLSClientAuthentication)clientAuthentication;
        if (this.pkiCertBindingVerifier != null) {
            this.pkiCertBindingVerifier.verifyCertificateBinding(clientAuthentication.getClientID(), pKITLSClientAuthentication.getClientX509Certificate(), context);
            return;
        } else {
            if (this.certBindingVerifier == null) throw new InvalidClientException("Mutual TLS client Authentication (tls_client_auth) not supported");
            this.certBindingVerifier.verifyCertificateBinding(clientAuthentication.getClientID(), pKITLSClientAuthentication.getClientX509CertificateSubjectDN(), context);
        }
    }
}

