/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.ECDSASigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.MACSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.RSASSASigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWSProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca.JCAContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;

public class JWTAssertionFactory {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet<JWSAlgorithm> hashSet = new HashSet<JWSAlgorithm>();
        hashSet.addAll(JWSAlgorithm.Family.HMAC_SHA);
        hashSet.addAll(JWSAlgorithm.Family.RSA);
        hashSet.addAll(JWSAlgorithm.Family.EC);
        return Collections.unmodifiableSet(hashSet);
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, Secret secret) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(jWSAlgorithm), jWTAssertionDetails.toJWTClaimsSet());
        signedJWT.sign(new MACSigner(secret.getValueBytes()));
        return signedJWT;
    }

    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, PrivateKey privateKey, String string, List<Base64> list, Base64URL base64URL, Provider provider) throws JOSEException {
        BaseJWSProvider baseJWSProvider;
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(jWSAlgorithm).keyID(string).x509CertChain(list).x509CertSHA256Thumbprint(base64URL).build(), jWTAssertionDetails.toJWTClaimsSet());
        if (RSASSASigner.SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            baseJWSProvider = new RSASSASigner(privateKey);
        } else if (ECDSASigner.SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            Set<Curve> set = Curve.forJWSAlgorithm(jWSAlgorithm);
            if (set.size() != 1) {
                throw new JOSEException("Couldn't determine curve for JWS algorithm: " + jWSAlgorithm);
            }
            baseJWSProvider = new ECDSASigner(privateKey, set.iterator().next());
        } else {
            throw new JOSEException("Unsupported JWS algorithm: " + jWSAlgorithm);
        }
        if (provider != null) {
            ((JCAContext)baseJWSProvider.getJCAContext()).setProvider(provider);
        }
        signedJWT.sign((JWSSigner)((Object)baseJWSProvider));
        return signedJWT;
    }

    @Deprecated
    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, RSAPrivateKey rSAPrivateKey, String string, Provider provider) throws JOSEException {
        return JWTAssertionFactory.create(jWTAssertionDetails, jWSAlgorithm, rSAPrivateKey, string, null, null, provider);
    }

    @Deprecated
    public static SignedJWT create(JWTAssertionDetails jWTAssertionDetails, JWSAlgorithm jWSAlgorithm, ECPrivateKey eCPrivateKey, String string, Provider provider) throws JOSEException {
        return JWTAssertionFactory.create(jWTAssertionDetails, jWSAlgorithm, eCPrivateKey, string, null, null, provider);
    }

    private JWTAssertionFactory() {
    }
}

