/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GeneralException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerEndpointMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.ReadOnlyAuthorizationServerEndpointMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.ReadOnlyAuthorizationServerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.BackChannelTokenDeliveryMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequestConfigurator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Prompt;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.registration.ClientRegistrationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.EndpointName;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class AuthorizationServerMetadata
extends AuthorizationServerEndpointMetadata
implements ReadOnlyAuthorizationServerMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Issuer issuer;
    private URI jwkSetURI;
    private Scope scope;
    private List<ResponseType> rts;
    private List<ResponseMode> rms;
    private List<GrantType> gts;
    private List<CodeChallengeMethod> codeChallengeMethods;
    private List<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private List<JWSAlgorithm> tokenEndpointJWSAlgs;
    private List<ClientAuthenticationMethod> introspectionEndpointAuthMethods;
    private List<JWSAlgorithm> introspectionEndpointJWSAlgs;
    private List<ClientAuthenticationMethod> revocationEndpointAuthMethods;
    private List<JWSAlgorithm> revocationEndpointJWSAlgs;
    private List<JWSAlgorithm> requestObjectJWSAlgs;
    private List<JWEAlgorithm> requestObjectJWEAlgs;
    private List<EncryptionMethod> requestObjectJWEEncs;
    private boolean requestParamSupported = false;
    private boolean requestURIParamSupported = false;
    private boolean requireRequestURIReg = false;
    private boolean authzResponseIssParameterSupported = false;
    private List<LangTag> uiLocales;
    private URI serviceDocsURI;
    private URI policyURI;
    private URI tosURI;
    private AuthorizationServerEndpointMetadata mtlsEndpointAliases;
    private boolean tlsClientCertificateBoundAccessTokens = false;
    private List<JWSAlgorithm> dPoPJWSAlgs;
    private List<JWSAlgorithm> authzJWSAlgs;
    private List<JWEAlgorithm> authzJWEAlgs;
    private List<EncryptionMethod> authzJWEEncs;
    private boolean requirePAR = false;
    private List<AuthorizationType> authzTypes;
    private List<ClientType> incrementalAuthzTypes;
    private List<BackChannelTokenDeliveryMode> backChannelTokenDeliveryModes;
    private List<JWSAlgorithm> backChannelAuthRequestJWSAlgs;
    private boolean backChannelUserCodeSupported = false;
    private List<Prompt.Type> promptTypes;
    private String organizationName;
    private JWKSet jwkSet;
    private URI signedJWKSetURI;
    private List<ClientRegistrationType> clientRegistrationTypes;
    private Map<EndpointName, List<ClientAuthenticationMethod>> clientRegistrationAuthMethods;
    private List<JWSAlgorithm> clientRegistrationAuthJWSAlgs;
    private URI federationRegistrationEndpoint;
    private final JSONObject customParameters = new JSONObject();

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public AuthorizationServerMetadata(Issuer issuer) {
        URI uRI;
        try {
            uRI = new URI(issuer.getValue());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("The issuer identifier must be a URI: " + uRISyntaxException.getMessage(), uRISyntaxException);
        }
        if (uRI.getRawQuery() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a query component");
        }
        if (uRI.getRawFragment() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a fragment component");
        }
        this.issuer = issuer;
    }

    @Override
    public Issuer getIssuer() {
        return this.issuer;
    }

    @Override
    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public void setJWKSetURI(URI uRI) {
        this.jwkSetURI = uRI;
    }

    @Override
    public Scope getScopes() {
        return this.scope;
    }

    public void setScopes(Scope scope) {
        this.scope = scope;
    }

    @Override
    public List<ResponseType> getResponseTypes() {
        return this.rts;
    }

    public void setResponseTypes(List<ResponseType> list) {
        this.rts = list;
    }

    @Override
    public List<ResponseMode> getResponseModes() {
        return this.rms;
    }

    public void setResponseModes(List<ResponseMode> list) {
        this.rms = list;
    }

    @Override
    public List<GrantType> getGrantTypes() {
        return this.gts;
    }

    public void setGrantTypes(List<GrantType> list) {
        this.gts = list;
    }

    @Override
    public List<CodeChallengeMethod> getCodeChallengeMethods() {
        return this.codeChallengeMethods;
    }

    public void setCodeChallengeMethods(List<CodeChallengeMethod> list) {
        this.codeChallengeMethods = list;
    }

    @Override
    public List<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public void setTokenEndpointAuthMethods(List<ClientAuthenticationMethod> list) {
        this.tokenEndpointAuthMethods = list;
    }

    @Override
    public List<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public void setTokenEndpointJWSAlgs(List<JWSAlgorithm> list) {
        if (list != null && list.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The \"none\" algorithm is not accepted");
        }
        this.tokenEndpointJWSAlgs = list;
    }

    @Override
    public List<ClientAuthenticationMethod> getIntrospectionEndpointAuthMethods() {
        return this.introspectionEndpointAuthMethods;
    }

    public void setIntrospectionEndpointAuthMethods(List<ClientAuthenticationMethod> list) {
        this.introspectionEndpointAuthMethods = list;
    }

    @Override
    public List<JWSAlgorithm> getIntrospectionEndpointJWSAlgs() {
        return this.introspectionEndpointJWSAlgs;
    }

    public void setIntrospectionEndpointJWSAlgs(List<JWSAlgorithm> list) {
        if (list != null && list.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The \"none\" algorithm is not accepted");
        }
        this.introspectionEndpointJWSAlgs = list;
    }

    @Override
    public List<ClientAuthenticationMethod> getRevocationEndpointAuthMethods() {
        return this.revocationEndpointAuthMethods;
    }

    public void setRevocationEndpointAuthMethods(List<ClientAuthenticationMethod> list) {
        this.revocationEndpointAuthMethods = list;
    }

    @Override
    public List<JWSAlgorithm> getRevocationEndpointJWSAlgs() {
        return this.revocationEndpointJWSAlgs;
    }

    public void setRevocationEndpointJWSAlgs(List<JWSAlgorithm> list) {
        if (list != null && list.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The \"none\" algorithm is not accepted");
        }
        this.revocationEndpointJWSAlgs = list;
    }

    @Override
    public List<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public void setRequestObjectJWSAlgs(List<JWSAlgorithm> list) {
        this.requestObjectJWSAlgs = list;
    }

    @Override
    public List<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public void setRequestObjectJWEAlgs(List<JWEAlgorithm> list) {
        this.requestObjectJWEAlgs = list;
    }

    @Override
    public List<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public void setRequestObjectJWEEncs(List<EncryptionMethod> list) {
        this.requestObjectJWEEncs = list;
    }

    @Override
    public boolean supportsRequestParam() {
        return this.requestParamSupported;
    }

    public void setSupportsRequestParam(boolean bl2) {
        this.requestParamSupported = bl2;
    }

    @Override
    public boolean supportsRequestURIParam() {
        return this.requestURIParamSupported;
    }

    public void setSupportsRequestURIParam(boolean bl2) {
        this.requestURIParamSupported = bl2;
    }

    @Override
    public boolean requiresRequestURIRegistration() {
        return this.requireRequestURIReg;
    }

    public void setRequiresRequestURIRegistration(boolean bl2) {
        this.requireRequestURIReg = bl2;
    }

    @Override
    public boolean supportsAuthorizationResponseIssuerParam() {
        return this.authzResponseIssParameterSupported;
    }

    public void setSupportsAuthorizationResponseIssuerParam(boolean bl2) {
        this.authzResponseIssParameterSupported = bl2;
    }

    @Override
    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public void setUILocales(List<LangTag> list) {
        this.uiLocales = list;
    }

    @Override
    public URI getServiceDocsURI() {
        return this.serviceDocsURI;
    }

    public void setServiceDocsURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.serviceDocsURI = uRI;
    }

    @Override
    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.policyURI = uRI;
    }

    @Override
    public URI getTermsOfServiceURI() {
        return this.tosURI;
    }

    public void setTermsOfServiceURI(URI uRI) {
        URIUtils.ensureSchemeIsHTTPSorHTTP(uRI);
        this.tosURI = uRI;
    }

    @Override
    public ReadOnlyAuthorizationServerEndpointMetadata getReadOnlyMtlsEndpointAliases() {
        return this.getMtlsEndpointAliases();
    }

    public AuthorizationServerEndpointMetadata getMtlsEndpointAliases() {
        return this.mtlsEndpointAliases;
    }

    public void setMtlsEndpointAliases(AuthorizationServerEndpointMetadata authorizationServerEndpointMetadata) {
        this.mtlsEndpointAliases = authorizationServerEndpointMetadata;
    }

    @Override
    public boolean supportsTLSClientCertificateBoundAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    public void setSupportsTLSClientCertificateBoundAccessTokens(boolean bl2) {
        this.tlsClientCertificateBoundAccessTokens = bl2;
    }

    @Override
    @Deprecated
    public boolean supportsMutualTLSSenderConstrainedAccessTokens() {
        return this.supportsTLSClientCertificateBoundAccessTokens();
    }

    @Deprecated
    public void setSupportsMutualTLSSenderConstrainedAccessTokens(boolean bl2) {
        this.setSupportsTLSClientCertificateBoundAccessTokens(bl2);
    }

    @Override
    public List<JWSAlgorithm> getDPoPJWSAlgs() {
        return this.dPoPJWSAlgs;
    }

    public void setDPoPJWSAlgs(List<JWSAlgorithm> list) {
        this.dPoPJWSAlgs = list;
    }

    @Override
    public List<JWSAlgorithm> getAuthorizationJWSAlgs() {
        return this.authzJWSAlgs;
    }

    public void setAuthorizationJWSAlgs(List<JWSAlgorithm> list) {
        this.authzJWSAlgs = list;
    }

    @Override
    public List<JWEAlgorithm> getAuthorizationJWEAlgs() {
        return this.authzJWEAlgs;
    }

    public void setAuthorizationJWEAlgs(List<JWEAlgorithm> list) {
        this.authzJWEAlgs = list;
    }

    @Override
    public List<EncryptionMethod> getAuthorizationJWEEncs() {
        return this.authzJWEEncs;
    }

    public void setAuthorizationJWEEncs(List<EncryptionMethod> list) {
        this.authzJWEEncs = list;
    }

    @Override
    public boolean requiresPushedAuthorizationRequests() {
        return this.requirePAR;
    }

    public void requiresPushedAuthorizationRequests(boolean bl2) {
        this.requirePAR = bl2;
    }

    @Override
    public List<AuthorizationType> getAuthorizationDetailsTypes() {
        return this.authzTypes;
    }

    public void setAuthorizationDetailsTypes(List<AuthorizationType> list) {
        this.authzTypes = list;
    }

    @Override
    public List<ClientType> getIncrementalAuthorizationTypes() {
        return this.incrementalAuthzTypes;
    }

    public void setIncrementalAuthorizationTypes(List<ClientType> list) {
        this.incrementalAuthzTypes = list;
    }

    @Override
    public List<BackChannelTokenDeliveryMode> getBackChannelTokenDeliveryModes() {
        return this.backChannelTokenDeliveryModes;
    }

    public void setBackChannelTokenDeliveryModes(List<BackChannelTokenDeliveryMode> list) {
        this.backChannelTokenDeliveryModes = list;
    }

    @Override
    public List<JWSAlgorithm> getBackChannelAuthenticationRequestJWSAlgs() {
        return this.backChannelAuthRequestJWSAlgs;
    }

    public void setBackChannelAuthenticationRequestJWSAlgs(List<JWSAlgorithm> list) {
        this.backChannelAuthRequestJWSAlgs = list;
    }

    @Override
    public boolean supportsBackChannelUserCodeParam() {
        return this.backChannelUserCodeSupported;
    }

    public void setSupportsBackChannelUserCodeParam(boolean bl2) {
        this.backChannelUserCodeSupported = bl2;
    }

    @Override
    public List<Prompt.Type> getPromptTypes() {
        return this.promptTypes;
    }

    public void setPromptTypes(List<Prompt.Type> list) {
        this.promptTypes = list;
    }

    @Override
    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String string) {
        this.organizationName = string;
    }

    @Override
    public JWKSet getJWKSet() {
        return this.jwkSet;
    }

    public void setJWKSet(JWKSet jWKSet) {
        this.jwkSet = jWKSet;
    }

    @Override
    public URI getSignedJWKSetURI() {
        return this.signedJWKSetURI;
    }

    public void setSignedJWKSetURI(URI uRI) {
        this.signedJWKSetURI = uRI;
    }

    @Override
    public List<ClientRegistrationType> getClientRegistrationTypes() {
        return this.clientRegistrationTypes;
    }

    public void setClientRegistrationTypes(List<ClientRegistrationType> list) {
        this.clientRegistrationTypes = list;
    }

    @Override
    public Map<EndpointName, List<ClientAuthenticationMethod>> getClientRegistrationAuthnMethods() {
        return this.clientRegistrationAuthMethods;
    }

    public void setClientRegistrationAuthnMethods(Map<EndpointName, List<ClientAuthenticationMethod>> map) {
        this.clientRegistrationAuthMethods = map;
    }

    @Override
    public List<JWSAlgorithm> getClientRegistrationAuthnJWSAlgs() {
        return this.clientRegistrationAuthJWSAlgs;
    }

    public void setClientRegistrationAuthnJWSAlgs(List<JWSAlgorithm> list) {
        this.clientRegistrationAuthJWSAlgs = list;
    }

    @Override
    public URI getFederationRegistrationEndpointURI() {
        return this.federationRegistrationEndpoint;
    }

    @Override
    public void setFederationRegistrationEndpointURI(URI uRI) {
        this.federationRegistrationEndpoint = uRI;
    }

    @Override
    public Object getCustomParameter(String string) {
        return this.customParameters.get(string);
    }

    @Override
    public URI getCustomURIParameter(String string) {
        try {
            return JSONObjectUtils.getURI(this.customParameters, string, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setCustomParameter(String string, Object object) {
        if (REGISTERED_PARAMETER_NAMES.contains(string)) {
            throw new IllegalArgumentException("The " + string + " parameter is registered");
        }
        this.customParameters.put(string, object);
    }

    @Override
    public JSONObject getCustomParameters() {
        return this.customParameters;
    }

    public void applyDefaults() {
        if (this.rms == null) {
            this.rms = new ArrayList<ResponseMode>(2);
            this.rms.add(ResponseMode.QUERY);
            this.rms.add(ResponseMode.FRAGMENT);
        }
        if (this.gts == null) {
            this.gts = new ArrayList<GrantType>(2);
            this.gts.add(GrantType.AUTHORIZATION_CODE);
            this.gts.add(GrantType.IMPLICIT);
        }
        if (this.tokenEndpointAuthMethods == null) {
            this.tokenEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            this.tokenEndpointAuthMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        }
    }

    @Override
    public JSONObject toJSONObject() {
        ArrayList<String> arrayList;
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("issuer", this.issuer.getValue());
        if (this.jwkSetURI != null) {
            jSONObject.put("jwks_uri", this.jwkSetURI.toString());
        }
        if (this.scope != null) {
            jSONObject.put("scopes_supported", this.scope.toStringList());
        }
        if (this.rts != null) {
            arrayList = new ArrayList<String>(this.rts.size());
            for (ResponseType object : this.rts) {
                arrayList.add(object.toString());
            }
            jSONObject.put("response_types_supported", arrayList);
        }
        if (this.rms != null) {
            arrayList = new ArrayList(this.rms.size());
            for (ResponseMode responseMode : this.rms) {
                arrayList.add(responseMode.getValue());
            }
            jSONObject.put("response_modes_supported", arrayList);
        }
        if (this.gts != null) {
            arrayList = new ArrayList(this.gts.size());
            for (GrantType grantType : this.gts) {
                arrayList.add(grantType.toString());
            }
            jSONObject.put("grant_types_supported", arrayList);
        }
        if (this.codeChallengeMethods != null) {
            arrayList = new ArrayList(this.codeChallengeMethods.size());
            for (CodeChallengeMethod codeChallengeMethod : this.codeChallengeMethods) {
                arrayList.add(codeChallengeMethod.getValue());
            }
            jSONObject.put("code_challenge_methods_supported", arrayList);
        }
        if (this.tokenEndpointAuthMethods != null) {
            arrayList = new ArrayList(this.tokenEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.tokenEndpointAuthMethods) {
                arrayList.add(clientAuthenticationMethod.getValue());
            }
            jSONObject.put("token_endpoint_auth_methods_supported", arrayList);
        }
        if (this.tokenEndpointJWSAlgs != null) {
            arrayList = new ArrayList(this.tokenEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.tokenEndpointJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("token_endpoint_auth_signing_alg_values_supported", arrayList);
        }
        if (this.introspectionEndpointAuthMethods != null) {
            arrayList = new ArrayList(this.introspectionEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.introspectionEndpointAuthMethods) {
                arrayList.add(clientAuthenticationMethod.getValue());
            }
            jSONObject.put("introspection_endpoint_auth_methods_supported", arrayList);
        }
        if (this.introspectionEndpointJWSAlgs != null) {
            arrayList = new ArrayList(this.introspectionEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.introspectionEndpointJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("introspection_endpoint_auth_signing_alg_values_supported", arrayList);
        }
        if (this.revocationEndpointAuthMethods != null) {
            arrayList = new ArrayList(this.revocationEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.revocationEndpointAuthMethods) {
                arrayList.add(clientAuthenticationMethod.getValue());
            }
            jSONObject.put("revocation_endpoint_auth_methods_supported", arrayList);
        }
        if (this.revocationEndpointJWSAlgs != null) {
            arrayList = new ArrayList(this.revocationEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.revocationEndpointJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("revocation_endpoint_auth_signing_alg_values_supported", arrayList);
        }
        if (this.requestObjectJWSAlgs != null) {
            arrayList = new ArrayList(this.requestObjectJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.requestObjectJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("request_object_signing_alg_values_supported", arrayList);
        }
        if (this.requestObjectJWEAlgs != null) {
            arrayList = new ArrayList(this.requestObjectJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.requestObjectJWEAlgs) {
                arrayList.add(jWEAlgorithm.getName());
            }
            jSONObject.put("request_object_encryption_alg_values_supported", arrayList);
        }
        if (this.requestObjectJWEEncs != null) {
            arrayList = new ArrayList(this.requestObjectJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.requestObjectJWEEncs) {
                arrayList.add(encryptionMethod.getName());
            }
            jSONObject.put("request_object_encryption_enc_values_supported", arrayList);
        }
        if (this.uiLocales != null) {
            arrayList = new ArrayList(this.uiLocales.size());
            for (LangTag langTag : this.uiLocales) {
                arrayList.add(langTag.toString());
            }
            jSONObject.put("ui_locales_supported", arrayList);
        }
        if (this.serviceDocsURI != null) {
            jSONObject.put("service_documentation", this.serviceDocsURI.toString());
        }
        if (this.policyURI != null) {
            jSONObject.put("op_policy_uri", this.policyURI.toString());
        }
        if (this.tosURI != null) {
            jSONObject.put("op_tos_uri", this.tosURI.toString());
        }
        if (this.requestParamSupported) {
            jSONObject.put("request_parameter_supported", true);
        }
        if (this.requestURIParamSupported) {
            jSONObject.put("request_uri_parameter_supported", true);
        }
        if (this.requireRequestURIReg) {
            jSONObject.put("require_request_uri_registration", true);
        }
        if (this.authzResponseIssParameterSupported) {
            jSONObject.put("authorization_response_iss_parameter_supported", true);
        }
        if (this.mtlsEndpointAliases != null) {
            jSONObject.put("mtls_endpoint_aliases", this.mtlsEndpointAliases.toJSONObject());
        }
        if (this.tlsClientCertificateBoundAccessTokens) {
            jSONObject.put("tls_client_certificate_bound_access_tokens", true);
        }
        if (this.dPoPJWSAlgs != null) {
            arrayList = new ArrayList(this.dPoPJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.dPoPJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("dpop_signing_alg_values_supported", arrayList);
        }
        if (this.authzJWSAlgs != null) {
            arrayList = new ArrayList(this.authzJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.authzJWSAlgs) {
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("authorization_signing_alg_values_supported", arrayList);
        }
        if (this.authzJWEAlgs != null) {
            arrayList = new ArrayList(this.authzJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.authzJWEAlgs) {
                arrayList.add(jWEAlgorithm.getName());
            }
            jSONObject.put("authorization_encryption_alg_values_supported", arrayList);
        }
        if (this.authzJWEEncs != null) {
            arrayList = new ArrayList(this.authzJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.authzJWEEncs) {
                arrayList.add(encryptionMethod.getName());
            }
            jSONObject.put("authorization_encryption_enc_values_supported", arrayList);
        }
        if (this.requirePAR) {
            jSONObject.put("require_pushed_authorization_requests", true);
        }
        if (this.authzTypes != null) {
            jSONObject.put("authorization_details_types_supported", Identifier.toStringList(this.authzTypes));
        }
        if (CollectionUtils.isNotEmpty(this.incrementalAuthzTypes)) {
            arrayList = new ArrayList(this.incrementalAuthzTypes.size());
            for (ClientType clientType : this.incrementalAuthzTypes) {
                if (clientType == null) continue;
                arrayList.add(clientType.name().toLowerCase());
            }
            jSONObject.put("incremental_authz_types_supported", arrayList);
        }
        if (this.backChannelTokenDeliveryModes != null) {
            arrayList = new ArrayList(this.backChannelTokenDeliveryModes.size());
            for (BackChannelTokenDeliveryMode backChannelTokenDeliveryMode : this.backChannelTokenDeliveryModes) {
                if (backChannelTokenDeliveryMode == null) continue;
                arrayList.add(backChannelTokenDeliveryMode.getValue());
            }
            jSONObject.put("backchannel_token_delivery_modes_supported", arrayList);
        }
        if (this.backChannelAuthRequestJWSAlgs != null) {
            arrayList = new ArrayList(this.backChannelAuthRequestJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.backChannelAuthRequestJWSAlgs) {
                if (jWSAlgorithm == null) continue;
                arrayList.add(jWSAlgorithm.getName());
            }
            jSONObject.put("backchannel_authentication_request_signing_alg_values_supported", arrayList);
        }
        if (this.backChannelUserCodeSupported) {
            jSONObject.put("backchannel_user_code_parameter_supported", true);
        }
        if (this.promptTypes != null) {
            arrayList = new ArrayList(this.promptTypes.size());
            for (Prompt.Type type : this.promptTypes) {
                arrayList.add(type.toString());
            }
            jSONObject.put("prompt_values_supported", arrayList);
        }
        if (this.organizationName != null) {
            jSONObject.put("organization_name", this.organizationName);
        }
        if (CollectionUtils.isNotEmpty(this.clientRegistrationTypes)) {
            jSONObject.put("client_registration_types_supported", Identifier.toStringList(this.clientRegistrationTypes));
            if (this.jwkSet != null) {
                jSONObject.put("jwks", JSONObjectUtils.toJSONObject(this.jwkSet.toPublicJWKSet()));
            } else if (this.signedJWKSetURI != null) {
                jSONObject.put("signed_jwks_uri", this.signedJWKSetURI.toString());
            }
            if (this.clientRegistrationTypes.contains(ClientRegistrationType.AUTOMATIC) && MapUtils.isNotEmpty(this.clientRegistrationAuthMethods)) {
                Iterator<JWSAlgorithm> iterator = new JSONObject();
                for (Map.Entry<EndpointName, List<ClientAuthenticationMethod>> entry : this.getClientRegistrationAuthnMethods().entrySet()) {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    for (ClientAuthenticationMethod clientAuthenticationMethod : entry.getValue()) {
                        linkedList.add(clientAuthenticationMethod.getValue());
                    }
                    ((HashMap)((Object)iterator)).put(entry.getKey().getValue(), linkedList);
                }
                jSONObject.put("request_authentication_methods_supported", iterator);
            }
            if (this.clientRegistrationTypes.contains(ClientRegistrationType.AUTOMATIC) && CollectionUtils.isNotEmpty(this.clientRegistrationAuthJWSAlgs)) {
                arrayList = new ArrayList(this.clientRegistrationAuthJWSAlgs.size());
                for (JWSAlgorithm jWSAlgorithm : this.clientRegistrationAuthJWSAlgs) {
                    arrayList.add(jWSAlgorithm.getName());
                }
                jSONObject.put("request_authentication_signing_alg_values_supported", arrayList);
            }
            if (this.clientRegistrationTypes.contains(ClientRegistrationType.EXPLICIT) && this.federationRegistrationEndpoint != null) {
                jSONObject.put("federation_registration_endpoint", this.federationRegistrationEndpoint.toString());
            } else {
                jSONObject.remove("federation_registration_endpoint");
            }
        }
        jSONObject.putAll(this.customParameters);
        return jSONObject;
    }

    public static AuthorizationServerMetadata parse(JSONObject jSONObject) throws ParseException {
        Object object;
        Object object2;
        AuthorizationServerMetadata authorizationServerMetadata;
        Issuer issuer = new Issuer(JSONObjectUtils.getURI(jSONObject, "issuer").toString());
        AuthorizationServerEndpointMetadata authorizationServerEndpointMetadata = AuthorizationServerEndpointMetadata.parse(jSONObject);
        try {
            authorizationServerMetadata = new AuthorizationServerMetadata(issuer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        authorizationServerMetadata.setAuthorizationEndpointURI(authorizationServerEndpointMetadata.getAuthorizationEndpointURI());
        authorizationServerMetadata.setTokenEndpointURI(authorizationServerEndpointMetadata.getTokenEndpointURI());
        authorizationServerMetadata.setRegistrationEndpointURI(authorizationServerEndpointMetadata.getRegistrationEndpointURI());
        authorizationServerMetadata.setIntrospectionEndpointURI(authorizationServerEndpointMetadata.getIntrospectionEndpointURI());
        authorizationServerMetadata.setRevocationEndpointURI(authorizationServerEndpointMetadata.getRevocationEndpointURI());
        authorizationServerMetadata.setRequestObjectEndpoint(authorizationServerEndpointMetadata.getRequestObjectEndpoint());
        authorizationServerMetadata.setPushedAuthorizationRequestEndpointURI(authorizationServerEndpointMetadata.getPushedAuthorizationRequestEndpointURI());
        authorizationServerMetadata.setDeviceAuthorizationEndpointURI(authorizationServerEndpointMetadata.getDeviceAuthorizationEndpointURI());
        authorizationServerMetadata.setBackChannelAuthenticationEndpointURI(authorizationServerEndpointMetadata.getBackChannelAuthenticationEndpointURI());
        authorizationServerMetadata.jwkSetURI = JSONObjectUtils.getURI(jSONObject, "jwks_uri", null);
        if (jSONObject.get("scopes_supported") != null) {
            authorizationServerMetadata.scope = new Scope();
            for (String object3 : JSONObjectUtils.getStringArray(jSONObject, "scopes_supported")) {
                if (object3 == null) continue;
                authorizationServerMetadata.scope.add(new Scope.Value(object3));
            }
        }
        if (jSONObject.get("response_types_supported") != null) {
            authorizationServerMetadata.rts = new ArrayList<ResponseType>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "response_types_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.rts.add(ResponseType.parse(string));
            }
        }
        if (jSONObject.get("response_modes_supported") != null) {
            authorizationServerMetadata.rms = new ArrayList<ResponseMode>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "response_modes_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.rms.add(new ResponseMode(string));
            }
        }
        if (jSONObject.get("grant_types_supported") != null) {
            authorizationServerMetadata.gts = new ArrayList<GrantType>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "grant_types_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.gts.add(GrantType.parse(string));
            }
        }
        if (jSONObject.get("code_challenge_methods_supported") != null) {
            authorizationServerMetadata.codeChallengeMethods = new ArrayList<CodeChallengeMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "code_challenge_methods_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.codeChallengeMethods.add(CodeChallengeMethod.parse(string));
            }
        }
        if (jSONObject.get("token_endpoint_auth_methods_supported") != null) {
            authorizationServerMetadata.tokenEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "token_endpoint_auth_methods_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.tokenEndpointAuthMethods.add(ClientAuthenticationMethod.parse(string));
            }
        }
        if (jSONObject.get("token_endpoint_auth_signing_alg_values_supported") != null) {
            authorizationServerMetadata.tokenEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "token_endpoint_auth_signing_alg_values_supported")) {
                if (string != null && string.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (string == null) continue;
                authorizationServerMetadata.tokenEndpointJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("introspection_endpoint_auth_methods_supported") != null) {
            authorizationServerMetadata.introspectionEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "introspection_endpoint_auth_methods_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.introspectionEndpointAuthMethods.add(ClientAuthenticationMethod.parse(string));
            }
        }
        if (jSONObject.get("introspection_endpoint_auth_signing_alg_values_supported") != null) {
            authorizationServerMetadata.introspectionEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "introspection_endpoint_auth_signing_alg_values_supported")) {
                if (string != null && string.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (string == null) continue;
                authorizationServerMetadata.introspectionEndpointJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("revocation_endpoint_auth_methods_supported") != null) {
            authorizationServerMetadata.revocationEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "revocation_endpoint_auth_methods_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.revocationEndpointAuthMethods.add(ClientAuthenticationMethod.parse(string));
            }
        }
        if (jSONObject.get("revocation_endpoint_auth_signing_alg_values_supported") != null) {
            authorizationServerMetadata.revocationEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "revocation_endpoint_auth_signing_alg_values_supported")) {
                if (string != null && string.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (string == null) continue;
                authorizationServerMetadata.revocationEndpointJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("request_object_signing_alg_values_supported") != null) {
            authorizationServerMetadata.requestObjectJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "request_object_signing_alg_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.requestObjectJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("request_object_encryption_alg_values_supported") != null) {
            authorizationServerMetadata.requestObjectJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "request_object_encryption_alg_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.requestObjectJWEAlgs.add(JWEAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("request_object_encryption_enc_values_supported") != null) {
            authorizationServerMetadata.requestObjectJWEEncs = new ArrayList<EncryptionMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "request_object_encryption_enc_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.requestObjectJWEEncs.add(EncryptionMethod.parse(string));
            }
        }
        if (jSONObject.get("ui_locales_supported") != null) {
            authorizationServerMetadata.uiLocales = new ArrayList<LangTag>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "ui_locales_supported")) {
                if (string == null) continue;
                try {
                    authorizationServerMetadata.uiLocales.add(LangTag.parse(string));
                }
                catch (LangTagException langTagException) {
                    throw new ParseException("Invalid ui_locales_supported field: " + langTagException.getMessage(), langTagException);
                }
            }
        }
        if (jSONObject.get("service_documentation") != null) {
            try {
                authorizationServerMetadata.setServiceDocsURI(JSONObjectUtils.getURI(jSONObject, "service_documentation"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException("Illegal service_documentation parameter: " + illegalArgumentException.getMessage());
            }
        }
        if (jSONObject.get("op_policy_uri") != null) {
            try {
                authorizationServerMetadata.setPolicyURI(JSONObjectUtils.getURI(jSONObject, "op_policy_uri"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException("Illegal op_policy_uri parameter: " + illegalArgumentException.getMessage());
            }
        }
        if (jSONObject.get("op_tos_uri") != null) {
            try {
                authorizationServerMetadata.setTermsOfServiceURI(JSONObjectUtils.getURI(jSONObject, "op_tos_uri"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException("Illegal op_tos_uri parameter: " + illegalArgumentException.getMessage());
            }
        }
        if (jSONObject.get("request_parameter_supported") != null) {
            authorizationServerMetadata.requestParamSupported = JSONObjectUtils.getBoolean(jSONObject, "request_parameter_supported");
        }
        if (jSONObject.get("request_uri_parameter_supported") != null) {
            authorizationServerMetadata.requestURIParamSupported = JSONObjectUtils.getBoolean(jSONObject, "request_uri_parameter_supported");
        }
        if (jSONObject.get("require_request_uri_registration") != null) {
            authorizationServerMetadata.requireRequestURIReg = JSONObjectUtils.getBoolean(jSONObject, "require_request_uri_registration");
        }
        if (jSONObject.get("authorization_response_iss_parameter_supported") != null) {
            authorizationServerMetadata.authzResponseIssParameterSupported = JSONObjectUtils.getBoolean(jSONObject, "authorization_response_iss_parameter_supported");
        }
        if (jSONObject.get("mtls_endpoint_aliases") != null) {
            authorizationServerMetadata.mtlsEndpointAliases = AuthorizationServerEndpointMetadata.parse(JSONObjectUtils.getJSONObject(jSONObject, "mtls_endpoint_aliases"));
        }
        if (jSONObject.get("tls_client_certificate_bound_access_tokens") != null) {
            authorizationServerMetadata.tlsClientCertificateBoundAccessTokens = JSONObjectUtils.getBoolean(jSONObject, "tls_client_certificate_bound_access_tokens");
        }
        if (jSONObject.get("dpop_signing_alg_values_supported") != null) {
            authorizationServerMetadata.dPoPJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "dpop_signing_alg_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.dPoPJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("authorization_signing_alg_values_supported") != null) {
            authorizationServerMetadata.authzJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "authorization_signing_alg_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.authzJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("authorization_encryption_alg_values_supported") != null) {
            authorizationServerMetadata.authzJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "authorization_encryption_alg_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.authzJWEAlgs.add(JWEAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("authorization_encryption_enc_values_supported") != null) {
            authorizationServerMetadata.authzJWEEncs = new ArrayList<EncryptionMethod>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "authorization_encryption_enc_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.authzJWEEncs.add(EncryptionMethod.parse(string));
            }
        }
        if (jSONObject.get("require_pushed_authorization_requests") != null) {
            authorizationServerMetadata.requiresPushedAuthorizationRequests(JSONObjectUtils.getBoolean(jSONObject, "require_pushed_authorization_requests"));
        }
        if (jSONObject.get("authorization_details_types_supported") != null) {
            authorizationServerMetadata.authzTypes = new ArrayList<AuthorizationType>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "authorization_details_types_supported")) {
                if (!StringUtils.isNotBlank(string)) continue;
                authorizationServerMetadata.authzTypes.add(new AuthorizationType(string));
            }
        }
        if (jSONObject.get("incremental_authz_types_supported") != null) {
            authorizationServerMetadata.incrementalAuthzTypes = new ArrayList<ClientType>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "incremental_authz_types_supported")) {
                if (string == null) continue;
                try {
                    object2 = ClientType.valueOf(string.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Illegal client type in incremental_authz_types_supported field: " + string);
                }
                authorizationServerMetadata.incrementalAuthzTypes.add((ClientType)((Object)object2));
            }
        }
        if (jSONObject.get("backchannel_token_delivery_modes_supported") != null) {
            authorizationServerMetadata.backChannelTokenDeliveryModes = new ArrayList<BackChannelTokenDeliveryMode>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "backchannel_token_delivery_modes_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.backChannelTokenDeliveryModes.add(BackChannelTokenDeliveryMode.parse(string));
            }
        }
        if (jSONObject.get("backchannel_authentication_request_signing_alg_values_supported") != null) {
            authorizationServerMetadata.backChannelAuthRequestJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String string : JSONObjectUtils.getStringArray(jSONObject, "backchannel_authentication_request_signing_alg_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.backChannelAuthRequestJWSAlgs.add(JWSAlgorithm.parse(string));
            }
        }
        if (jSONObject.get("backchannel_user_code_parameter_supported") != null) {
            authorizationServerMetadata.backChannelUserCodeSupported = JSONObjectUtils.getBoolean(jSONObject, "backchannel_user_code_parameter_supported");
        }
        if (jSONObject.get("prompt_values_supported") != null) {
            authorizationServerMetadata.promptTypes = new ArrayList<Prompt.Type>();
            for (String string : JSONObjectUtils.getStringList(jSONObject, "prompt_values_supported")) {
                if (string == null) continue;
                authorizationServerMetadata.promptTypes.add(Prompt.Type.parse(string));
            }
        }
        if (jSONObject.get("client_registration_types_supported") != null) {
            authorizationServerMetadata.clientRegistrationTypes = new LinkedList<ClientRegistrationType>();
            for (String string : JSONObjectUtils.getStringList(jSONObject, "client_registration_types_supported")) {
                authorizationServerMetadata.clientRegistrationTypes.add(new ClientRegistrationType(string));
            }
            if (jSONObject.get("jwks") != null) {
                try {
                    authorizationServerMetadata.jwkSet = JWKSet.parse(JSONObjectUtils.getJSONObject(jSONObject, "jwks"));
                }
                catch (java.text.ParseException parseException) {
                    throw new ParseException(parseException.getMessage(), parseException);
                }
            }
            authorizationServerMetadata.signedJWKSetURI = JSONObjectUtils.getURI(jSONObject, "signed_jwks_uri", null);
            if (jSONObject.get("request_authentication_methods_supported") != null) {
                object = new HashMap();
                JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "request_authentication_methods_supported");
                for (String string : jSONObject2.keySet()) {
                    object2 = JSONObjectUtils.getStringList(jSONObject2, string, Collections.emptyList());
                    LinkedList<ClientAuthenticationMethod> linkedList = new LinkedList<ClientAuthenticationMethod>();
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        linkedList.add(ClientAuthenticationMethod.parse(string2));
                    }
                    object.put(new EndpointName(string), linkedList);
                }
                authorizationServerMetadata.setClientRegistrationAuthnMethods((Map<EndpointName, List<ClientAuthenticationMethod>>)object);
            }
            if (jSONObject.get("request_authentication_signing_alg_values_supported") != null) {
                authorizationServerMetadata.clientRegistrationAuthJWSAlgs = new ArrayList<JWSAlgorithm>();
                for (String string : JSONObjectUtils.getStringArray(jSONObject, "request_authentication_signing_alg_values_supported")) {
                    if (string == null) continue;
                    authorizationServerMetadata.clientRegistrationAuthJWSAlgs.add(JWSAlgorithm.parse(string));
                }
            }
            authorizationServerMetadata.federationRegistrationEndpoint = JSONObjectUtils.getURI(jSONObject, "federation_registration_endpoint", null);
        }
        authorizationServerMetadata.organizationName = JSONObjectUtils.getString(jSONObject, "organization_name", null);
        object = new JSONObject(jSONObject);
        ((HashMap)object).keySet().removeAll(REGISTERED_PARAMETER_NAMES);
        for (Map.Entry entry : ((HashMap)object).entrySet()) {
            authorizationServerMetadata.setCustomParameter((String)entry.getKey(), entry.getValue());
        }
        return authorizationServerMetadata;
    }

    public static AuthorizationServerMetadata parse(String string) throws ParseException {
        return AuthorizationServerMetadata.parse(JSONObjectUtils.parse(string));
    }

    public static URL resolveURL(Issuer issuer) throws GeneralException {
        try {
            URL uRL = new URL(issuer.getValue());
            if (uRL.getQuery() != null && !uRL.getQuery().trim().isEmpty()) {
                throw new GeneralException("The issuer identifier must not contain a query component");
            }
            if (uRL.getPath() != null && uRL.getPath().endsWith("/")) {
                return new URL(uRL + ".well-known/oauth-authorization-server");
            }
            return new URL(uRL + "/.well-known/oauth-authorization-server");
        }
        catch (MalformedURLException malformedURLException) {
            throw new GeneralException("The issuer identifier doesn't represent a valid URL: " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static AuthorizationServerMetadata resolve(Issuer issuer) throws GeneralException, IOException {
        return AuthorizationServerMetadata.resolve(issuer, 0, 0);
    }

    public static AuthorizationServerMetadata resolve(Issuer issuer, final int n2, final int n3) throws GeneralException, IOException {
        HTTPRequestConfigurator hTTPRequestConfigurator = new HTTPRequestConfigurator(){

            @Override
            public void configure(HTTPRequest hTTPRequest) {
                hTTPRequest.setConnectTimeout(n2);
                hTTPRequest.setReadTimeout(n3);
            }
        };
        return AuthorizationServerMetadata.resolve(issuer, hTTPRequestConfigurator);
    }

    public static AuthorizationServerMetadata resolve(Issuer issuer, HTTPRequestConfigurator hTTPRequestConfigurator) throws GeneralException, IOException {
        URL uRL = AuthorizationServerMetadata.resolveURL(issuer);
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, uRL);
        hTTPRequestConfigurator.configure(hTTPRequest);
        HTTPResponse hTTPResponse = hTTPRequest.send();
        if (hTTPResponse.getStatusCode() != 200) {
            throw new IOException("Couldn't download OAuth 2.0 Authorization Server metadata from " + uRL + ": Status code " + hTTPResponse.getStatusCode());
        }
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        AuthorizationServerMetadata authorizationServerMetadata = AuthorizationServerMetadata.parse(jSONObject);
        if (!issuer.equals(authorizationServerMetadata.issuer)) {
            throw new GeneralException("The returned issuer doesn't match the expected: " + authorizationServerMetadata.getIssuer());
        }
        return authorizationServerMetadata;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(AuthorizationServerEndpointMetadata.getRegisteredParameterNames());
        hashSet.add("issuer");
        hashSet.add("jwks_uri");
        hashSet.add("scopes_supported");
        hashSet.add("response_types_supported");
        hashSet.add("response_modes_supported");
        hashSet.add("grant_types_supported");
        hashSet.add("code_challenge_methods_supported");
        hashSet.add("token_endpoint_auth_methods_supported");
        hashSet.add("token_endpoint_auth_signing_alg_values_supported");
        hashSet.add("request_parameter_supported");
        hashSet.add("request_uri_parameter_supported");
        hashSet.add("require_request_uri_registration");
        hashSet.add("request_object_signing_alg_values_supported");
        hashSet.add("request_object_encryption_alg_values_supported");
        hashSet.add("request_object_encryption_enc_values_supported");
        hashSet.add("ui_locales_supported");
        hashSet.add("service_documentation");
        hashSet.add("op_policy_uri");
        hashSet.add("op_tos_uri");
        hashSet.add("introspection_endpoint_auth_methods_supported");
        hashSet.add("introspection_endpoint_auth_signing_alg_values_supported");
        hashSet.add("revocation_endpoint_auth_methods_supported");
        hashSet.add("revocation_endpoint_auth_signing_alg_values_supported");
        hashSet.add("mtls_endpoint_aliases");
        hashSet.add("tls_client_certificate_bound_access_tokens");
        hashSet.add("dpop_signing_alg_values_supported");
        hashSet.add("authorization_signing_alg_values_supported");
        hashSet.add("authorization_encryption_alg_values_supported");
        hashSet.add("authorization_encryption_enc_values_supported");
        hashSet.add("require_pushed_authorization_requests");
        hashSet.add("authorization_details_types_supported");
        hashSet.add("incremental_authz_types_supported");
        hashSet.add("authorization_response_iss_parameter_supported");
        hashSet.add("backchannel_token_delivery_modes_supported");
        hashSet.add("backchannel_authentication_request_signing_alg_values_supported");
        hashSet.add("backchannel_user_code_parameter_supported");
        hashSet.add("prompt_values_supported");
        hashSet.add("organization_name");
        hashSet.add("jwks");
        hashSet.add("signed_jwks_uri");
        hashSet.add("client_registration_types_supported");
        hashSet.add("request_authentication_methods_supported");
        hashSet.add("request_authentication_signing_alg_values_supported");
        hashSet.add("federation_registration_endpoint");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

