/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class ErrorObject
implements Serializable {
    private static final long serialVersionUID = -361808781364656206L;
    private final String code;
    private final String description;
    private final int httpStatusCode;
    private final URI uri;
    private final Map<String, String> customParams;

    public ErrorObject(String string) {
        this(string, null, 0, null);
    }

    public ErrorObject(String string, String string2) {
        this(string, string2, 0, null);
    }

    public ErrorObject(String string, String string2, int n2) {
        this(string, string2, n2, null);
    }

    public ErrorObject(String string, String string2, int n2, URI uRI) {
        this(string, string2, n2, uRI, null);
    }

    public ErrorObject(String string, String string2, int n2, URI uRI, Map<String, String> map) {
        if (!ErrorObject.isLegal(string)) {
            throw new IllegalArgumentException("Illegal char(s) in code, see RFC 6749, section 5.2");
        }
        this.code = string;
        if (!ErrorObject.isLegal(string2)) {
            throw new IllegalArgumentException("Illegal char(s) in description, see RFC 6749, section 5.2");
        }
        this.description = string2;
        this.httpStatusCode = n2;
        this.uri = uRI;
        this.customParams = map;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public ErrorObject setDescription(String string) {
        return new ErrorObject(this.getCode(), string, this.getHTTPStatusCode(), this.getURI(), this.getCustomParams());
    }

    public ErrorObject appendDescription(String string) {
        String string2 = this.getDescription() != null ? this.getDescription() + string : string;
        return new ErrorObject(this.getCode(), string2, this.getHTTPStatusCode(), this.getURI(), this.getCustomParams());
    }

    public int getHTTPStatusCode() {
        return this.httpStatusCode;
    }

    public ErrorObject setHTTPStatusCode(int n2) {
        return new ErrorObject(this.getCode(), this.getDescription(), n2, this.getURI(), this.getCustomParams());
    }

    public URI getURI() {
        return this.uri;
    }

    public ErrorObject setURI(URI uRI) {
        return new ErrorObject(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), uRI, this.getCustomParams());
    }

    public Map<String, String> getCustomParams() {
        if (MapUtils.isNotEmpty(this.customParams)) {
            return Collections.unmodifiableMap(this.customParams);
        }
        return Collections.emptyMap();
    }

    public ErrorObject setCustomParams(Map<String, String> map) {
        return new ErrorObject(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), map);
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.getCode() != null) {
            jSONObject.put("error", this.getCode());
        }
        if (this.getDescription() != null) {
            jSONObject.put("error_description", this.getDescription());
        }
        if (this.getURI() != null) {
            jSONObject.put("error_uri", this.getURI().toString());
        }
        if (!this.getCustomParams().isEmpty()) {
            jSONObject.putAll(this.getCustomParams());
        }
        return jSONObject;
    }

    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.getCode() != null) {
            hashMap.put("error", Collections.singletonList(this.getCode()));
        }
        if (this.getDescription() != null) {
            hashMap.put("error_description", Collections.singletonList(this.getDescription()));
        }
        if (this.getURI() != null) {
            hashMap.put("error_uri", Collections.singletonList(this.getURI().toString()));
        }
        if (!this.getCustomParams().isEmpty()) {
            for (Map.Entry<String, String> entry : this.getCustomParams().entrySet()) {
                hashMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
        return hashMap;
    }

    public HTTPResponse toHTTPResponse() {
        int n2 = this.getHTTPStatusCode() > 0 ? this.getHTTPStatusCode() : 400;
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        if (this.getCode() != null) {
            hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
            hTTPResponse.setContent(this.toJSONObject().toJSONString());
        }
        return hTTPResponse;
    }

    public String toString() {
        return this.code != null ? this.code : "null";
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : "null".hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ErrorObject && this.toString().equals(object.toString());
    }

    public static ErrorObject parse(JSONObject jSONObject) {
        String string = null;
        try {
            string = JSONObjectUtils.getString(jSONObject, "error", null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (!ErrorObject.isLegal(string)) {
            string = null;
        }
        String string2 = null;
        try {
            string2 = JSONObjectUtils.getString(jSONObject, "error_description", null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        URI uRI = null;
        try {
            uRI = JSONObjectUtils.getURI(jSONObject, "error_uri", null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        HashMap hashMap = null;
        for (Map.Entry entry : jSONObject.entrySet()) {
            if ("error".equals(entry.getKey()) || "error_description".equals(entry.getKey()) || "error_uri".equals(entry.getKey()) || entry.getValue() != null && !(entry.getValue() instanceof String)) continue;
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            hashMap.put(entry.getKey(), (String)entry.getValue());
        }
        return new ErrorObject(string, ErrorObject.removeIllegalChars(string2), 0, uRI, hashMap);
    }

    public static ErrorObject parse(Map<String, List<String>> map) {
        String string = MultivaluedMapUtils.getFirstValue(map, "error");
        String string2 = MultivaluedMapUtils.getFirstValue(map, "error_description");
        String string3 = MultivaluedMapUtils.getFirstValue(map, "error_uri");
        if (!ErrorObject.isLegal(string)) {
            string = null;
        }
        URI uRI = null;
        if (string3 != null) {
            try {
                uRI = new URI(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        HashMap<String, String> hashMap = null;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if ("error".equals(entry.getKey()) || "error_description".equals(entry.getKey()) || "error_uri".equals(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            if (entry.getValue() == null) {
                hashMap.put(entry.getKey(), null);
                continue;
            }
            if (entry.getValue().isEmpty()) continue;
            hashMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return new ErrorObject(string, ErrorObject.removeIllegalChars(string2), 0, uRI, hashMap);
    }

    public static ErrorObject parse(HTTPResponse hTTPResponse) {
        JSONObject jSONObject;
        try {
            jSONObject = hTTPResponse.getContentAsJSONObject();
        }
        catch (ParseException parseException) {
            return new ErrorObject(null, null, hTTPResponse.getStatusCode());
        }
        ErrorObject errorObject = ErrorObject.parse(jSONObject);
        return new ErrorObject(errorObject.getCode(), errorObject.description, hTTPResponse.getStatusCode(), errorObject.getURI(), errorObject.getCustomParams());
    }

    public static String removeIllegalChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (!ErrorObject.isLegal(c2)) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static boolean isLegal(String string) {
        if (string == null) {
            return true;
        }
        for (char c2 : string.toCharArray()) {
            if (ErrorObject.isLegal(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegal(char c2) {
        if (c2 > '\u007f') {
            return false;
        }
        return c2 >= ' ' && c2 <= '!' || c2 >= '#' && c2 <= '[' || c2 >= ']' && c2 <= '~';
    }
}

