/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class AuthorizationCodeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.AUTHORIZATION_CODE;
    private final AuthorizationCode code;
    private final URI redirectURI;
    private final CodeVerifier codeVerifier;

    public AuthorizationCodeGrant(AuthorizationCode authorizationCode, URI uRI) {
        this(authorizationCode, uRI, null);
    }

    public AuthorizationCodeGrant(AuthorizationCode authorizationCode, URI uRI, CodeVerifier codeVerifier) {
        super(GRANT_TYPE);
        if (authorizationCode == null) {
            throw new IllegalArgumentException("The authorisation code must not be null");
        }
        this.code = authorizationCode;
        this.redirectURI = uRI;
        this.codeVerifier = codeVerifier;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public CodeVerifier getCodeVerifier() {
        return this.codeVerifier;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        linkedHashMap.put("code", Collections.singletonList(this.code.getValue()));
        if (this.redirectURI != null) {
            linkedHashMap.put("redirect_uri", Collections.singletonList(this.redirectURI.toString()));
        }
        if (this.codeVerifier != null) {
            linkedHashMap.put("code_verifier", Collections.singletonList(this.codeVerifier.getValue()));
        }
        return linkedHashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AuthorizationCodeGrant)) {
            return false;
        }
        AuthorizationCodeGrant authorizationCodeGrant = (AuthorizationCodeGrant)object;
        return this.code.equals(authorizationCodeGrant.code) && Objects.equals(this.redirectURI, authorizationCodeGrant.redirectURI) && Objects.equals(this.getCodeVerifier(), authorizationCodeGrant.getCodeVerifier());
    }

    public int hashCode() {
        return Objects.hash(this.code, this.redirectURI, this.getCodeVerifier());
    }

    public static AuthorizationCodeGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        String string = MultivaluedMapUtils.getFirstValue(map, "code");
        if (string == null || string.trim().isEmpty()) {
            String string2 = "Missing or empty code parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        AuthorizationCode authorizationCode = new AuthorizationCode(string);
        String string3 = MultivaluedMapUtils.getFirstValue(map, "redirect_uri");
        URI uRI = null;
        if (string3 != null) {
            try {
                uRI = new URI(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string4 = "Invalid redirect_uri parameter: " + uRISyntaxException.getMessage();
                throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4), uRISyntaxException);
            }
        }
        String string5 = MultivaluedMapUtils.getFirstValue(map, "code_verifier");
        CodeVerifier codeVerifier = null;
        if (StringUtils.isNotBlank(string5)) {
            try {
                codeVerifier = new CodeVerifier(string5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string6 = "Illegal code verifier: " + illegalArgumentException.getMessage();
                throw new ParseException(illegalArgumentException.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + string6), illegalArgumentException);
            }
        }
        return new AuthorizationCodeGrant(authorizationCode, uRI, codeVerifier);
    }
}

