/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.GsonBuilder;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.ToNumberPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;

public class JSONObjectUtils {
    private static final Gson GSON = new GsonBuilder().serializeNulls().setObjectToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).disableHtmlEscaping().create();

    public static Map<String, Object> parse(String string) throws ParseException {
        return JSONObjectUtils.parse(string, -1);
    }

    public static Map<String, Object> parse(String string, int n2) throws ParseException {
        if (string.trim().isEmpty()) {
            throw new ParseException("Invalid JSON object", 0);
        }
        if (n2 >= 0 && string.length() > n2) {
            throw new ParseException("The parsed string is longer than the max accepted size of " + n2 + " characters", 0);
        }
        Type type = TypeToken.getParameterized(Map.class, new Type[]{String.class, Object.class}).getType();
        try {
            return (Map)GSON.fromJson(string, type);
        }
        catch (Exception exception) {
            throw new ParseException("Invalid JSON: " + exception.getMessage(), 0);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new ParseException("Excessive JSON object and / or array nesting", 0);
        }
    }

    @Deprecated
    public static Map<String, Object> parseJSONObject(String string) throws ParseException {
        return JSONObjectUtils.parse(string);
    }

    private static <T> T getGeneric(Map<String, Object> map, String string, Class<T> clazz) throws ParseException {
        if (map.get(string) == null) {
            return null;
        }
        Object object = map.get(string);
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new ParseException("Unexpected type of JSON object member " + string + "", 0);
        }
        Object object2 = object;
        return (T)object2;
    }

    public static boolean getBoolean(Map<String, Object> map, String string) throws ParseException {
        Boolean bl2 = JSONObjectUtils.getGeneric(map, string, Boolean.class);
        if (bl2 == null) {
            throw new ParseException("JSON object member " + string + " is missing or null", 0);
        }
        return bl2;
    }

    public static int getInt(Map<String, Object> map, String string) throws ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new ParseException("JSON object member " + string + " is missing or null", 0);
        }
        return number.intValue();
    }

    public static long getLong(Map<String, Object> map, String string) throws ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new ParseException("JSON object member " + string + " is missing or null", 0);
        }
        return number.longValue();
    }

    public static float getFloat(Map<String, Object> map, String string) throws ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new ParseException("JSON object member " + string + " is missing or null", 0);
        }
        return number.floatValue();
    }

    public static double getDouble(Map<String, Object> map, String string) throws ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new ParseException("JSON object member " + string + " is missing or null", 0);
        }
        return number.doubleValue();
    }

    public static String getString(Map<String, Object> map, String string) throws ParseException {
        return JSONObjectUtils.getGeneric(map, string, String.class);
    }

    public static URI getURI(Map<String, Object> map, String string) throws ParseException {
        String string2 = JSONObjectUtils.getString(map, string);
        if (string2 == null) {
            return null;
        }
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), 0);
        }
    }

    public static List<Object> getJSONArray(Map<String, Object> map, String string) throws ParseException {
        List list = JSONObjectUtils.getGeneric(map, string, List.class);
        return list;
    }

    public static String[] getStringArray(Map<String, Object> map, String string) throws ParseException {
        List<Object> list = JSONObjectUtils.getJSONArray(map, string);
        if (list == null) {
            return null;
        }
        try {
            return list.toArray(new String[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ParseException("JSON object member " + string + " is not an array of strings", 0);
        }
    }

    public static Map<String, Object>[] getJSONObjectArray(Map<String, Object> map, String string) throws ParseException {
        List<Object> list = JSONObjectUtils.getJSONArray(map, string);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new HashMap[0];
        }
        for (Object object : list) {
            if (object == null || !(object instanceof Map)) continue;
            try {
                return list.toArray(new Map[0]);
            }
            catch (ArrayStoreException arrayStoreException) {
                break;
            }
        }
        throw new ParseException("JSON object member " + string + " is not an array of JSON objects", 0);
    }

    public static List<String> getStringList(Map<String, Object> map, String string) throws ParseException {
        String[] stringArray = JSONObjectUtils.getStringArray(map, string);
        if (stringArray == null) {
            return null;
        }
        return Arrays.asList(stringArray);
    }

    public static Map<String, Object> getJSONObject(Map<String, Object> map, String string) throws ParseException {
        Map map2 = JSONObjectUtils.getGeneric(map, string, Map.class);
        if (map2 == null) {
            return null;
        }
        for (Object k2 : map2.keySet()) {
            if (k2 instanceof String) continue;
            throw new ParseException("JSON object member " + string + " not a JSON object", 0);
        }
        Map map3 = map2;
        return map3;
    }

    public static Base64URL getBase64URL(Map<String, Object> map, String string) throws ParseException {
        String string2 = JSONObjectUtils.getString(map, string);
        if (string2 == null) {
            return null;
        }
        return new Base64URL(string2);
    }

    public static Date getEpochSecondAsDate(Map<String, Object> map, String string) throws ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            return null;
        }
        return DateUtils.fromSecondsSinceEpoch(number.longValue());
    }

    public static String toJSONString(Map<String, ?> map) {
        return GSON.toJson(map);
    }

    public static Map<String, Object> newJSONObject() {
        return new HashMap<String, Object>();
    }

    private JSONObjectUtils() {
    }
}

