/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

public class IOUtils {
    public static String readInputStreamToString(InputStream inputStream) throws IOException {
        return IOUtils.readInputStreamToString(inputStream, StandardCharset.UTF_8);
    }

    public static String readInputStreamToString(InputStream inputStream, Charset charset) throws IOException {
        int n2 = 1024;
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);){
            int n3;
            while ((n3 = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) >= 0) {
                stringBuilder.append(cArray, 0, n3);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static String readFileToString(File file) throws IOException {
        return IOUtils.readInputStreamToString(new FileInputStream(file));
    }

    public static String readFileToString(File file, Charset charset) throws IOException {
        return IOUtils.readInputStreamToString(new FileInputStream(file), charset);
    }

    public static void closeSilently(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private IOUtils() {
    }
}

