/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.AbstractJWKSetSourceEvent;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSourceWrapper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RateLimitReachedException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.events.EventListener;

@ThreadSafe
public class RateLimitedJWKSetSource<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private final long minTimeInterval;
    private long nextOpeningTime = -1L;
    private int counter = 0;
    private final EventListener<RateLimitedJWKSetSource<C>, C> eventListener;

    public RateLimitedJWKSetSource(JWKSetSource<C> jWKSetSource, long l2, EventListener<RateLimitedJWKSetSource<C>, C> eventListener) {
        super(jWKSetSource);
        this.minTimeInterval = l2;
        this.eventListener = eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        boolean bl2;
        RateLimitedJWKSetSource rateLimitedJWKSetSource = this;
        synchronized (rateLimitedJWKSetSource) {
            if (this.nextOpeningTime <= l2) {
                this.nextOpeningTime = l2 + this.minTimeInterval;
                this.counter = 1;
                bl2 = false;
            } else {
                boolean bl3 = bl2 = this.counter <= 0;
                if (!bl2) {
                    --this.counter;
                }
            }
        }
        if (bl2) {
            if (this.eventListener != null) {
                this.eventListener.notify(new RateLimitedEvent(this, (SecurityContext)c2, null));
            }
            throw new RateLimitReachedException();
        }
        return this.getSource().getJWKSet(jWKSetCacheRefreshEvaluator, l2, c2);
    }

    public long getMinTimeInterval() {
        return this.minTimeInterval;
    }

    public static class RateLimitedEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<RateLimitedJWKSetSource<C>, C> {
        private RateLimitedEvent(RateLimitedJWKSetSource<C> rateLimitedJWKSetSource, C c2) {
            super(rateLimitedJWKSetSource, c2);
        }

        /* synthetic */ RateLimitedEvent(RateLimitedJWKSetSource rateLimitedJWKSetSource, SecurityContext securityContext, 1 var3_3) {
            this(rateLimitedJWKSetSource, securityContext);
        }
    }
}

