/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSourceWrapper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.health.HealthReport;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.health.HealthReportListener;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.health.HealthStatus;

@ThreadSafe
public class JWKSetSourceWithHealthStatusReporting<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private final HealthReportListener<JWKSetSourceWithHealthStatusReporting<C>, C> healthReportListener;

    public JWKSetSourceWithHealthStatusReporting(JWKSetSource<C> jWKSetSource, HealthReportListener<JWKSetSourceWithHealthStatusReporting<C>, C> healthReportListener) {
        super(jWKSetSource);
        Objects.requireNonNull(healthReportListener);
        this.healthReportListener = healthReportListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        JWKSet jWKSet;
        try {
            jWKSet = this.getSource().getJWKSet(jWKSetCacheRefreshEvaluator, l2, c2);
            this.healthReportListener.notify(new HealthReport<JWKSetSourceWithHealthStatusReporting, C>(this, HealthStatus.HEALTHY, l2, c2));
        }
        catch (Exception exception) {
            this.healthReportListener.notify(new HealthReport<JWKSetSourceWithHealthStatusReporting, C>(this, HealthStatus.NOT_HEALTHY, exception, l2, c2));
            throw exception;
        }
        return jWKSet;
    }
}

