/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyRevocation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.SecretJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ThumbprintUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IntegerOverflowException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

@Immutable
public final class OctetSequenceKey
extends JWK
implements SecretJWK {
    private static final long serialVersionUID = 1L;
    private final Base64URL k;

    @Deprecated
    public OctetSequenceKey(Base64URL base64URL, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL2, Base64URL base64URL3, List<Base64> list, KeyStore keyStore) {
        this(base64URL, keyUse, set, algorithm, string, uRI, base64URL2, base64URL3, list, null, null, null, keyStore);
    }

    @Deprecated
    public OctetSequenceKey(Base64URL base64URL, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL2, Base64URL base64URL3, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(base64URL, keyUse, set, algorithm, string, uRI, base64URL2, base64URL3, list, date, date2, date3, null, keyStore);
    }

    public OctetSequenceKey(Base64URL base64URL, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL2, Base64URL base64URL3, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        super(KeyType.OCT, keyUse, set, algorithm, string, uRI, base64URL2, base64URL3, list, date, date2, date3, keyRevocation, keyStore);
        this.k = Objects.requireNonNull(base64URL, "The key value must not be null");
    }

    public Base64URL getKeyValue() {
        return this.k;
    }

    public byte[] toByteArray() {
        return this.getKeyValue().decode();
    }

    @Override
    public SecretKey toSecretKey() {
        return this.toSecretKey("NONE");
    }

    public SecretKey toSecretKey(String string) {
        return new SecretKeySpec(this.toByteArray(), string);
    }

    @Override
    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("k", this.k.toString());
        linkedHashMap.put("kty", this.getKeyType().toString());
        return linkedHashMap;
    }

    @Override
    public boolean isPrivate() {
        return true;
    }

    @Override
    public OctetSequenceKey toPublicJWK() {
        return null;
    }

    @Override
    public int size() {
        try {
            return ByteUtils.safeBitLength(this.k.decode());
        }
        catch (IntegerOverflowException integerOverflowException) {
            throw new ArithmeticException(integerOverflowException.getMessage());
        }
    }

    @Override
    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = super.toJSONObject();
        map.put("k", this.k.toString());
        return map;
    }

    public static OctetSequenceKey parse(String string) throws ParseException {
        return OctetSequenceKey.parse(JSONObjectUtils.parse(string));
    }

    public static OctetSequenceKey parse(Map<String, Object> map) throws ParseException {
        if (!KeyType.OCT.equals(JWKMetadata.parseKeyType(map))) {
            throw new ParseException("The key type kty must be " + KeyType.OCT.getValue(), 0);
        }
        Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "k");
        try {
            return new OctetSequenceKey(base64URL, JWKMetadata.parseKeyUse(map), JWKMetadata.parseKeyOperations(map), JWKMetadata.parseAlgorithm(map), JWKMetadata.parseKeyID(map), JWKMetadata.parseX509CertURL(map), JWKMetadata.parseX509CertThumbprint(map), JWKMetadata.parseX509CertSHA256Thumbprint(map), JWKMetadata.parseX509CertChain(map), JWKMetadata.parseExpirationTime(map), JWKMetadata.parseNotBeforeTime(map), JWKMetadata.parseIssueTime(map), JWKMetadata.parseKeyRevocation(map), null);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), 0);
        }
    }

    public static OctetSequenceKey load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Key key;
        try {
            key = keyStore.getKey(string, cArray);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            throw new JOSEException("Couldn't retrieve secret key (bad pin?): " + generalSecurityException.getMessage(), generalSecurityException);
        }
        if (!(key instanceof SecretKey)) {
            return null;
        }
        return new Builder((SecretKey)key).keyID(string).keyStore(keyStore).build();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OctetSequenceKey)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        OctetSequenceKey octetSequenceKey = (OctetSequenceKey)object;
        return Objects.equals(this.k, octetSequenceKey.k);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.k);
    }

    public static class Builder {
        private final Base64URL k;
        private KeyUse use;
        private Set<KeyOperation> ops;
        private Algorithm alg;
        private String kid;
        private URI x5u;
        @Deprecated
        private Base64URL x5t;
        private Base64URL x5t256;
        private List<Base64> x5c;
        private Date exp;
        private Date nbf;
        private Date iat;
        private KeyRevocation revocation;
        private KeyStore ks;

        public Builder(Base64URL base64URL) {
            this.k = Objects.requireNonNull(base64URL);
        }

        public Builder(byte[] byArray) {
            this(Base64URL.encode(byArray));
            if (byArray.length == 0) {
                throw new IllegalArgumentException("The key must have a positive length");
            }
        }

        public Builder(SecretKey secretKey) {
            this(secretKey.getEncoded());
        }

        public Builder(OctetSequenceKey octetSequenceKey) {
            this.k = octetSequenceKey.k;
            this.use = octetSequenceKey.getKeyUse();
            this.ops = octetSequenceKey.getKeyOperations();
            this.alg = octetSequenceKey.getAlgorithm();
            this.kid = octetSequenceKey.getKeyID();
            this.x5u = octetSequenceKey.getX509CertURL();
            this.x5t = octetSequenceKey.getX509CertThumbprint();
            this.x5t256 = octetSequenceKey.getX509CertSHA256Thumbprint();
            this.x5c = octetSequenceKey.getX509CertChain();
            this.exp = octetSequenceKey.getExpirationTime();
            this.nbf = octetSequenceKey.getNotBeforeTime();
            this.iat = octetSequenceKey.getIssueTime();
            this.revocation = octetSequenceKey.getKeyRevocation();
            this.ks = octetSequenceKey.getKeyStore();
        }

        public Builder keyUse(KeyUse keyUse) {
            this.use = keyUse;
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> set) {
            this.ops = set;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.alg = algorithm;
            return this;
        }

        public Builder keyID(String string) {
            this.kid = string;
            return this;
        }

        public Builder keyIDFromThumbprint() throws JOSEException {
            return this.keyIDFromThumbprint("SHA-256");
        }

        public Builder keyIDFromThumbprint(String string) throws JOSEException {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("k", this.k.toString());
            linkedHashMap.put("kty", KeyType.OCT.getValue());
            this.kid = ThumbprintUtils.compute(string, linkedHashMap).toString();
            return this;
        }

        public Builder x509CertURL(URI uRI) {
            this.x5u = uRI;
            return this;
        }

        @Deprecated
        public Builder x509CertThumbprint(Base64URL base64URL) {
            this.x5t = base64URL;
            return this;
        }

        public Builder x509CertSHA256Thumbprint(Base64URL base64URL) {
            this.x5t256 = base64URL;
            return this;
        }

        public Builder x509CertChain(List<Base64> list) {
            this.x5c = list;
            return this;
        }

        public Builder expirationTime(Date date) {
            this.exp = date;
            return this;
        }

        public Builder notBeforeTime(Date date) {
            this.nbf = date;
            return this;
        }

        public Builder issueTime(Date date) {
            this.iat = date;
            return this;
        }

        public Builder keyRevocation(KeyRevocation keyRevocation) {
            this.revocation = keyRevocation;
            return this;
        }

        public Builder keyStore(KeyStore keyStore) {
            this.ks = keyStore;
            return this;
        }

        public OctetSequenceKey build() {
            try {
                return new OctetSequenceKey(this.k, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.exp, this.nbf, this.iat, this.revocation, this.ks);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

