/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;

@Immutable
public final class KeyRevocation
implements Serializable {
    private final Date revokedAt;
    private final Reason reason;

    public KeyRevocation(Date date, Reason reason) {
        this.revokedAt = Objects.requireNonNull(date);
        this.reason = reason;
    }

    public Date getRevocationTime() {
        return this.revokedAt;
    }

    public Reason getReason() {
        return this.reason;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyRevocation)) {
            return false;
        }
        KeyRevocation keyRevocation = (KeyRevocation)object;
        return Objects.equals(this.revokedAt, keyRevocation.revokedAt) && Objects.equals(this.getReason(), keyRevocation.getReason());
    }

    public int hashCode() {
        return Objects.hash(this.revokedAt, this.getReason());
    }

    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.put("revoked_at", DateUtils.toSecondsSinceEpoch(this.getRevocationTime()));
        if (this.getReason() != null) {
            map.put("reason", this.getReason().getValue());
        }
        return map;
    }

    public static KeyRevocation parse(Map<String, Object> map) throws ParseException {
        Date date = DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(map, "revoked_at"));
        Reason reason = null;
        if (map.get("reason") != null) {
            reason = Reason.parse(JSONObjectUtils.getString(map, "reason"));
        }
        return new KeyRevocation(date, reason);
    }

    public static class Reason {
        public static final Reason UNSPECIFIED = new Reason("unspecified");
        public static final Reason COMPROMISED = new Reason("compromised");
        public static final Reason SUPERSEDED = new Reason("superseded");
        private final String value;

        public Reason(String string) {
            this.value = Objects.requireNonNull(string);
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Reason)) {
                return false;
            }
            Reason reason = (Reason)object;
            return Objects.equals(this.getValue(), reason.getValue());
        }

        public int hashCode() {
            return Objects.hashCode(this.getValue());
        }

        public static Reason parse(String string) {
            if (UNSPECIFIED.getValue().equals(string)) {
                return UNSPECIFIED;
            }
            if (COMPROMISED.getValue().equals(string)) {
                return COMPROMISED;
            }
            if (SUPERSEDED.getValue().equals(string)) {
                return SUPERSEDED;
            }
            return new Reason(string);
        }
    }
}

