/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetSequenceKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.PasswordLookup;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.DefaultResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IOUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Resource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

@Immutable
public class JWKSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE = "application/jwk-set+json; charset=UTF-8";
    private final List<JWK> keys;
    private final Map<String, Object> customMembers;

    public JWKSet() {
        this(Collections.emptyList());
    }

    public JWKSet(JWK jWK) {
        this(Collections.singletonList(Objects.requireNonNull(jWK, "The JWK must not be null")));
    }

    public JWKSet(List<JWK> list) {
        this(list, Collections.emptyMap());
    }

    public JWKSet(List<JWK> list, Map<String, Object> map) {
        this.keys = Collections.unmodifiableList(Objects.requireNonNull(list, "The JWK list must not be null"));
        this.customMembers = Collections.unmodifiableMap(map);
    }

    public List<JWK> getKeys() {
        return this.keys;
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public int size() {
        return this.keys.size();
    }

    public JWK getKeyByKeyId(String string) {
        for (JWK jWK : this.getKeys()) {
            if (jWK.getKeyID() == null || !jWK.getKeyID().equals(string)) continue;
            return jWK;
        }
        return null;
    }

    public boolean containsJWK(JWK jWK) throws JOSEException {
        Base64URL base64URL = jWK.computeThumbprint();
        for (JWK jWK2 : this.getKeys()) {
            if (!base64URL.equals(jWK2.computeThumbprint())) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getAdditionalMembers() {
        return this.customMembers;
    }

    public JWKSet toPublicJWKSet() {
        LinkedList<JWK> linkedList = new LinkedList<JWK>();
        for (JWK jWK : this.keys) {
            JWK jWK2 = jWK.toPublicJWK();
            if (jWK2 == null) continue;
            linkedList.add(jWK2);
        }
        return new JWKSet(linkedList, this.customMembers);
    }

    public JWKSet filter(JWKMatcher jWKMatcher) {
        LinkedList<JWK> linkedList = new LinkedList<JWK>();
        for (JWK jWK : this.keys) {
            if (!jWKMatcher.matches(jWK)) continue;
            linkedList.add(jWK);
        }
        return new JWKSet(linkedList, this.customMembers);
    }

    public boolean containsNonPublicKeys() {
        for (JWK jWK : this.getKeys()) {
            if (!jWK.isPrivate()) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> toJSONObject() {
        return this.toJSONObject(true);
    }

    public Map<String, Object> toJSONObject(boolean bl2) {
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.putAll(this.customMembers);
        List<Object> list = JSONArrayUtils.newJSONArray();
        for (JWK jWK : this.keys) {
            if (bl2) {
                JWK jWK2 = jWK.toPublicJWK();
                if (jWK2 == null) continue;
                list.add(jWK2.toJSONObject());
                continue;
            }
            list.add(jWK.toJSONObject());
        }
        map.put("keys", list);
        return map;
    }

    public String toString(boolean bl2) {
        return JSONObjectUtils.toJSONString(this.toJSONObject(bl2));
    }

    public String toString() {
        return this.toString(true);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JWKSet)) {
            return false;
        }
        JWKSet jWKSet = (JWKSet)object;
        return this.getKeys().equals(jWKSet.getKeys()) && this.customMembers.equals(jWKSet.customMembers);
    }

    public int hashCode() {
        return Objects.hash(this.getKeys(), this.customMembers);
    }

    public static JWKSet parse(String string) throws ParseException {
        return JWKSet.parse(JSONObjectUtils.parse(string));
    }

    public static JWKSet parse(Map<String, Object> map) throws ParseException {
        List<Object> list = JSONObjectUtils.getJSONArray(map, "keys");
        if (list == null) {
            throw new ParseException("Missing required \"keys\" member", 0);
        }
        LinkedList<JWK> linkedList = new LinkedList<JWK>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            try {
                Map map2 = (Map)list.get(i2);
                linkedList.add(JWK.parse(map2));
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new ParseException("The \"keys\" JSON array must contain JSON objects only", 0);
            }
            catch (ParseException parseException) {
                if (parseException.getMessage() != null && parseException.getMessage().startsWith("Unsupported key type")) continue;
                throw new ParseException("Invalid JWK at position " + i2 + ": " + parseException.getMessage(), 0);
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equals("keys")) continue;
            hashMap.put((String)entry.getKey(), entry.getValue());
        }
        return new JWKSet(linkedList, hashMap);
    }

    public static JWKSet load(InputStream inputStream) throws IOException, ParseException {
        return JWKSet.parse(IOUtils.readInputStreamToString(inputStream, StandardCharset.UTF_8));
    }

    public static JWKSet load(File file) throws IOException, ParseException {
        return JWKSet.parse(IOUtils.readFileToString(file, StandardCharset.UTF_8));
    }

    public static JWKSet load(URL uRL, int n2, int n3, int n4) throws IOException, ParseException {
        return JWKSet.load(uRL, n2, n3, n4, null);
    }

    public static JWKSet load(URL uRL, int n2, int n3, int n4, Proxy proxy) throws IOException, ParseException {
        DefaultResourceRetriever defaultResourceRetriever = new DefaultResourceRetriever(n2, n3, n4);
        defaultResourceRetriever.setProxy(proxy);
        Resource resource = defaultResourceRetriever.retrieveResource(uRL);
        return JWKSet.parse(resource.getContent());
    }

    public static JWKSet load(URL uRL) throws IOException, ParseException {
        return JWKSet.load(uRL, 0, 0, 0);
    }

    public static JWKSet load(KeyStore keyStore, PasswordLookup passwordLookup) throws KeyStoreException {
        Serializable serializable;
        char[] cArray;
        String string;
        LinkedList<JWK> linkedList = new LinkedList<JWK>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            JWK jWK;
            string = enumeration.nextElement();
            char[] cArray2 = cArray = passwordLookup == null ? "".toCharArray() : passwordLookup.lookupPassword(string);
            serializable = keyStore.getCertificate(string);
            if (serializable == null) continue;
            if (serializable.getPublicKey() instanceof RSAPublicKey) {
                try {
                    jWK = RSAKey.load(keyStore, string, cArray);
                }
                catch (JOSEException jOSEException) {
                    continue;
                }
                if (jWK == null) continue;
                linkedList.add(jWK);
                continue;
            }
            if (!(serializable.getPublicKey() instanceof ECPublicKey)) continue;
            try {
                jWK = ECKey.load(keyStore, string, cArray);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (jWK == null) continue;
            linkedList.add(jWK);
        }
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            cArray = passwordLookup == null ? "".toCharArray() : passwordLookup.lookupPassword(string);
            try {
                serializable = OctetSequenceKey.load(keyStore, string, cArray);
            }
            catch (JOSEException jOSEException) {
                continue;
            }
            if (serializable == null) continue;
            linkedList.add((JWK)serializable);
        }
        return new JWKSet(linkedList);
    }
}

