/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.math.BigInteger;
import java.net.URI;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.utils.ECChecks;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.AsymmetricJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.CurveBasedJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyRevocation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ThumbprintUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.BigIntegerUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

@Immutable
public final class ECKey
extends JWK
implements AsymmetricJWK,
CurveBasedJWK {
    private static final long serialVersionUID = 1L;
    public static final Set<Curve> SUPPORTED_CURVES = Collections.unmodifiableSet(new HashSet<Curve>(Arrays.asList(Curve.P_256, Curve.SECP256K1, Curve.P_384, Curve.P_521)));
    private final Curve crv;
    private final Base64URL x;
    private final Base64URL y;
    private final Base64URL d;
    private final PrivateKey privateKey;

    public static Base64URL encodeCoordinate(int n2, BigInteger bigInteger) {
        int n3;
        byte[] byArray = BigIntegerUtils.toBytesUnsigned(bigInteger);
        if (byArray.length >= (n3 = (n2 + 7) / 8)) {
            return Base64URL.encode(byArray);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, n3 - byArray.length, byArray.length);
        return Base64URL.encode(byArray2);
    }

    private static void ensurePublicCoordinatesOnCurve(Curve curve, Base64URL base64URL, Base64URL base64URL2) {
        if (!SUPPORTED_CURVES.contains(curve)) {
            throw new IllegalArgumentException("Unknown / unsupported curve: " + curve);
        }
        if (!ECChecks.isPointOnCurve(base64URL.decodeToBigInteger(), base64URL2.decodeToBigInteger(), curve.toECParameterSpec())) {
            throw new IllegalArgumentException("Invalid EC JWK: The 'x' and 'y' public coordinates are not on the " + curve + " curve");
        }
    }

    @Deprecated
    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        this(curve, base64URL, base64URL2, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, null, null, null, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, KeyStore keyStore) {
        this(curve, base64URL, base64URL2, base64URL3, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, null, null, null, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        this(curve, base64URL, base64URL2, privateKey, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, null, null, null, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, ECPublicKey eCPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()), ECKey.encodeCoordinate(eCPrivateKey.getParams().getCurve().getField().getFieldSize(), eCPrivateKey.getS()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, ECPublicKey eCPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()), privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(curve, base64URL, base64URL2, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, date, date2, date3, null, keyStore);
    }

    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        super(KeyType.EC, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, date, date2, date3, keyRevocation, keyStore);
        this.crv = Objects.requireNonNull(curve, "The curve must not be null");
        this.x = Objects.requireNonNull(base64URL, "The x coordinate must not be null");
        this.y = Objects.requireNonNull(base64URL2, "The y coordinate must not be null");
        ECKey.ensurePublicCoordinatesOnCurve(curve, base64URL, base64URL2);
        this.ensureMatches(this.getParsedX509CertChain());
        this.d = null;
        this.privateKey = null;
    }

    @Deprecated
    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(curve, base64URL, base64URL2, base64URL3, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, date, date2, date3, null, keyStore);
    }

    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        super(KeyType.EC, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, date, date2, date3, keyRevocation, keyStore);
        this.crv = Objects.requireNonNull(curve, "The curve must not be null");
        this.x = Objects.requireNonNull(base64URL, "The x coordinate must not be null");
        this.y = Objects.requireNonNull(base64URL2, "The y coordinate must not be null");
        ECKey.ensurePublicCoordinatesOnCurve(curve, base64URL, base64URL2);
        this.ensureMatches(this.getParsedX509CertChain());
        this.d = Objects.requireNonNull(base64URL3, "The d coordinate must not be null");
        this.privateKey = null;
    }

    @Deprecated
    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(curve, base64URL, base64URL2, privateKey, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, date, date2, date3, null, keyStore);
    }

    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        super(KeyType.EC, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, date, date2, date3, keyRevocation, keyStore);
        this.crv = Objects.requireNonNull(curve, "The curve must not be null");
        this.x = Objects.requireNonNull(base64URL, "The x coordinate must not be null");
        this.y = Objects.requireNonNull(base64URL2, "The y coordinate must not be null");
        ECKey.ensurePublicCoordinatesOnCurve(curve, base64URL, base64URL2);
        this.ensureMatches(this.getParsedX509CertChain());
        this.d = null;
        this.privateKey = privateKey;
    }

    @Deprecated
    public ECKey(Curve curve, ECPublicKey eCPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(curve, eCPublicKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, null, keyStore);
    }

    public ECKey(Curve curve, ECPublicKey eCPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(curve, eCPublicKey, eCPrivateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, null, keyStore);
    }

    public ECKey(Curve curve, ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()), ECKey.encodeCoordinate(eCPrivateKey.getParams().getCurve().getField().getFieldSize(), eCPrivateKey.getS()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Deprecated
    public ECKey(Curve curve, ECPublicKey eCPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()), privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyStore);
    }

    public ECKey(Curve curve, ECPublicKey eCPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()), privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Override
    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public Base64URL getY() {
        return this.y;
    }

    public Base64URL getD() {
        return this.d;
    }

    public ECPublicKey toECPublicKey() throws JOSEException {
        return this.toECPublicKey(null);
    }

    public ECPublicKey toECPublicKey(Provider provider) throws JOSEException {
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        if (eCParameterSpec == null) {
            throw new JOSEException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPoint eCPoint = new ECPoint(this.x.decodeToBigInteger(), this.y.decodeToBigInteger());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        try {
            KeyFactory keyFactory = provider == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", provider);
            return (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public ECPrivateKey toECPrivateKey() throws JOSEException {
        return this.toECPrivateKey(null);
    }

    public ECPrivateKey toECPrivateKey(Provider provider) throws JOSEException {
        if (this.d == null) {
            return null;
        }
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        if (eCParameterSpec == null) {
            throw new JOSEException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(this.d.decodeToBigInteger(), eCParameterSpec);
        try {
            KeyFactory keyFactory = provider == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", provider);
            return (ECPrivateKey)keyFactory.generatePrivate(eCPrivateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public PublicKey toPublicKey() throws JOSEException {
        return this.toECPublicKey();
    }

    @Override
    public PrivateKey toPrivateKey() throws JOSEException {
        ECPrivateKey eCPrivateKey = this.toECPrivateKey();
        if (eCPrivateKey != null) {
            return eCPrivateKey;
        }
        return this.privateKey;
    }

    @Override
    public KeyPair toKeyPair() throws JOSEException {
        return this.toKeyPair(null);
    }

    public KeyPair toKeyPair(Provider provider) throws JOSEException {
        if (this.privateKey != null) {
            return new KeyPair(this.toECPublicKey(provider), this.privateKey);
        }
        return new KeyPair(this.toECPublicKey(provider), this.toECPrivateKey(provider));
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        ECPublicKey eCPublicKey;
        try {
            eCPublicKey = (ECPublicKey)this.getParsedX509CertChain().get(0).getPublicKey();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getX().decodeToBigInteger().equals(eCPublicKey.getW().getAffineX())) {
            return false;
        }
        return this.getY().decodeToBigInteger().equals(eCPublicKey.getW().getAffineY());
    }

    private void ensureMatches(List<X509Certificate> list) {
        if (list == null) {
            return;
        }
        if (!this.matches(list.get(0))) {
            throw new IllegalArgumentException("The public subject key info of the first X.509 certificate in the chain must match the JWK type and public parameters");
        }
    }

    @Override
    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("crv", this.crv.toString());
        linkedHashMap.put("kty", this.getKeyType().getValue());
        linkedHashMap.put("x", this.x.toString());
        linkedHashMap.put("y", this.y.toString());
        return linkedHashMap;
    }

    @Override
    public boolean isPrivate() {
        return this.d != null || this.privateKey != null;
    }

    @Override
    public int size() {
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        if (eCParameterSpec == null) {
            throw new UnsupportedOperationException("Couldn't determine field size for curve " + this.crv.getName());
        }
        return eCParameterSpec.getCurve().getField().getFieldSize();
    }

    @Override
    public ECKey toPublicJWK() {
        return new ECKey(this.getCurve(), this.getX(), this.getY(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertSHA256Thumbprint(), this.getX509CertChain(), this.getExpirationTime(), this.getNotBeforeTime(), this.getIssueTime(), this.getKeyRevocation(), this.getKeyStore());
    }

    @Override
    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = super.toJSONObject();
        map.put("crv", this.crv.toString());
        map.put("x", this.x.toString());
        map.put("y", this.y.toString());
        if (this.d != null) {
            map.put("d", this.d.toString());
        }
        return map;
    }

    public static ECKey parse(String string) throws ParseException {
        return ECKey.parse(JSONObjectUtils.parse(string));
    }

    public static ECKey parse(Map<String, Object> map) throws ParseException {
        Curve curve;
        if (!KeyType.EC.equals(JWKMetadata.parseKeyType(map))) {
            throw new ParseException("The key type \"kty\" must be EC", 0);
        }
        try {
            curve = Curve.parse(JSONObjectUtils.getString(map, "crv"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), 0);
        }
        Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "x");
        Base64URL base64URL2 = JSONObjectUtils.getBase64URL(map, "y");
        Base64URL base64URL3 = JSONObjectUtils.getBase64URL(map, "d");
        try {
            if (base64URL3 == null) {
                return new ECKey(curve, base64URL, base64URL2, JWKMetadata.parseKeyUse(map), JWKMetadata.parseKeyOperations(map), JWKMetadata.parseAlgorithm(map), JWKMetadata.parseKeyID(map), JWKMetadata.parseX509CertURL(map), JWKMetadata.parseX509CertThumbprint(map), JWKMetadata.parseX509CertSHA256Thumbprint(map), JWKMetadata.parseX509CertChain(map), JWKMetadata.parseExpirationTime(map), JWKMetadata.parseNotBeforeTime(map), JWKMetadata.parseIssueTime(map), JWKMetadata.parseKeyRevocation(map), null);
            }
            return new ECKey(curve, base64URL, base64URL2, base64URL3, JWKMetadata.parseKeyUse(map), JWKMetadata.parseKeyOperations(map), JWKMetadata.parseAlgorithm(map), JWKMetadata.parseKeyID(map), JWKMetadata.parseX509CertURL(map), JWKMetadata.parseX509CertThumbprint(map), JWKMetadata.parseX509CertSHA256Thumbprint(map), JWKMetadata.parseX509CertChain(map), JWKMetadata.parseExpirationTime(map), JWKMetadata.parseNotBeforeTime(map), JWKMetadata.parseIssueTime(map), JWKMetadata.parseKeyRevocation(map), null);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), 0);
        }
    }

    public static ECKey parse(X509Certificate x509Certificate) throws JOSEException {
        if (!(x509Certificate.getPublicKey() instanceof ECPublicKey)) {
            throw new JOSEException("The public key of the X.509 certificate is not EC");
        }
        ECPublicKey eCPublicKey = (ECPublicKey)x509Certificate.getPublicKey();
        try {
            JcaX509CertificateHolder jcaX509CertificateHolder = new JcaX509CertificateHolder(x509Certificate);
            String string = jcaX509CertificateHolder.getSubjectPublicKeyInfo().getAlgorithm().getParameters().toString();
            Curve curve = Curve.forOID(string);
            if (curve == null) {
                throw new JOSEException("Couldn't determine EC JWK curve for OID " + string);
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return new Builder(curve, eCPublicKey).keyUse(KeyUse.from(x509Certificate)).keyID(x509Certificate.getSerialNumber().toString(10)).x509CertChain(Collections.singletonList(Base64.encode(x509Certificate.getEncoded()))).x509CertSHA256Thumbprint(Base64URL.encode(messageDigest.digest(x509Certificate.getEncoded()))).expirationTime(x509Certificate.getNotAfter()).notBeforeTime(x509Certificate.getNotBefore()).build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Couldn't encode x5t parameter: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new JOSEException("Couldn't encode x5c parameter: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
    }

    public static ECKey load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Key key;
        Certificate certificate = keyStore.getCertificate(string);
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!(x509Certificate.getPublicKey() instanceof ECPublicKey)) {
            throw new JOSEException("Couldn't load EC JWK: The key algorithm is not EC");
        }
        ECKey eCKey = ECKey.parse(x509Certificate);
        eCKey = new Builder(eCKey).keyID(string).keyStore(keyStore).build();
        try {
            key = keyStore.getKey(string, cArray);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            throw new JOSEException("Couldn't retrieve private EC key (bad pin?): " + generalSecurityException.getMessage(), generalSecurityException);
        }
        if (key instanceof ECPrivateKey) {
            return new Builder(eCKey).privateKey((ECPrivateKey)key).build();
        }
        if (key instanceof PrivateKey && "EC".equalsIgnoreCase(key.getAlgorithm())) {
            return new Builder(eCKey).privateKey((PrivateKey)key).build();
        }
        return eCKey;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ECKey)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ECKey eCKey = (ECKey)object;
        return Objects.equals(this.crv, eCKey.crv) && Objects.equals(this.x, eCKey.x) && Objects.equals(this.y, eCKey.y) && Objects.equals(this.d, eCKey.d) && Objects.equals(this.privateKey, eCKey.privateKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.crv, this.x, this.y, this.d, this.privateKey);
    }

    public static class Builder {
        private final Curve crv;
        private final Base64URL x;
        private final Base64URL y;
        private Base64URL d;
        private PrivateKey priv;
        private KeyUse use;
        private Set<KeyOperation> ops;
        private Algorithm alg;
        private String kid;
        private URI x5u;
        @Deprecated
        private Base64URL x5t;
        private Base64URL x5t256;
        private List<Base64> x5c;
        private Date exp;
        private Date nbf;
        private Date iat;
        private KeyRevocation revocation;
        private KeyStore ks;

        public Builder(Curve curve, Base64URL base64URL, Base64URL base64URL2) {
            this.crv = Objects.requireNonNull(curve, "The curve must not be null");
            this.x = Objects.requireNonNull(base64URL, "The x coordinate must not be null");
            this.y = Objects.requireNonNull(base64URL2, "The y coordinate must not be null");
        }

        public Builder(Curve curve, ECPublicKey eCPublicKey) {
            this(curve, ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate(eCPublicKey.getParams().getCurve().getField().getFieldSize(), eCPublicKey.getW().getAffineY()));
        }

        public Builder(ECKey eCKey) {
            this.crv = eCKey.crv;
            this.x = eCKey.x;
            this.y = eCKey.y;
            this.d = eCKey.d;
            this.priv = eCKey.privateKey;
            this.use = eCKey.getKeyUse();
            this.ops = eCKey.getKeyOperations();
            this.alg = eCKey.getAlgorithm();
            this.kid = eCKey.getKeyID();
            this.x5u = eCKey.getX509CertURL();
            this.x5t = eCKey.getX509CertThumbprint();
            this.x5t256 = eCKey.getX509CertSHA256Thumbprint();
            this.x5c = eCKey.getX509CertChain();
            this.exp = eCKey.getExpirationTime();
            this.nbf = eCKey.getNotBeforeTime();
            this.iat = eCKey.getIssueTime();
            this.revocation = eCKey.getKeyRevocation();
            this.ks = eCKey.getKeyStore();
        }

        public Builder d(Base64URL base64URL) {
            this.d = base64URL;
            return this;
        }

        public Builder privateKey(ECPrivateKey eCPrivateKey) {
            this.d = eCPrivateKey != null ? ECKey.encodeCoordinate(eCPrivateKey.getParams().getCurve().getField().getFieldSize(), eCPrivateKey.getS()) : null;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            if (privateKey instanceof ECPrivateKey) {
                return this.privateKey((ECPrivateKey)privateKey);
            }
            if (privateKey != null && !"EC".equalsIgnoreCase(privateKey.getAlgorithm())) {
                throw new IllegalArgumentException("The private key algorithm must be EC");
            }
            this.priv = privateKey;
            return this;
        }

        public Builder keyUse(KeyUse keyUse) {
            this.use = keyUse;
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> set) {
            this.ops = set;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.alg = algorithm;
            return this;
        }

        public Builder keyID(String string) {
            this.kid = string;
            return this;
        }

        public Builder keyIDFromThumbprint() throws JOSEException {
            return this.keyIDFromThumbprint("SHA-256");
        }

        public Builder keyIDFromThumbprint(String string) throws JOSEException {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("crv", this.crv.toString());
            linkedHashMap.put("kty", KeyType.EC.getValue());
            linkedHashMap.put("x", this.x.toString());
            linkedHashMap.put("y", this.y.toString());
            this.kid = ThumbprintUtils.compute(string, linkedHashMap).toString();
            return this;
        }

        public Builder x509CertURL(URI uRI) {
            this.x5u = uRI;
            return this;
        }

        @Deprecated
        public Builder x509CertThumbprint(Base64URL base64URL) {
            this.x5t = base64URL;
            return this;
        }

        public Builder x509CertSHA256Thumbprint(Base64URL base64URL) {
            this.x5t256 = base64URL;
            return this;
        }

        public Builder x509CertChain(List<Base64> list) {
            this.x5c = list;
            return this;
        }

        public Builder expirationTime(Date date) {
            this.exp = date;
            return this;
        }

        public Builder notBeforeTime(Date date) {
            this.nbf = date;
            return this;
        }

        public Builder issueTime(Date date) {
            this.iat = date;
            return this;
        }

        public Builder keyRevocation(KeyRevocation keyRevocation) {
            this.revocation = keyRevocation;
            return this;
        }

        public Builder keyStore(KeyStore keyStore) {
            this.ks = keyStore;
            return this;
        }

        public ECKey build() {
            try {
                if (this.d == null && this.priv == null) {
                    return new ECKey(this.crv, this.x, this.y, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.exp, this.nbf, this.iat, this.revocation, this.ks);
                }
                if (this.priv != null) {
                    return new ECKey(this.crv, this.x, this.y, this.priv, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.exp, this.nbf, this.iat, this.revocation, this.ks);
                }
                return new ECKey(this.crv, this.x, this.y, this.d, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.exp, this.nbf, this.iat, this.revocation, this.ks);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

