/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.utils;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECChecks {
    public static boolean isPointOnCurve(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) {
        return ECChecks.isPointOnCurve(eCPublicKey, eCPrivateKey.getParams());
    }

    public static boolean isPointOnCurve(ECPublicKey eCPublicKey, ECParameterSpec eCParameterSpec) {
        ECPoint eCPoint = eCPublicKey.getW();
        return ECChecks.isPointOnCurve(eCPoint.getAffineX(), eCPoint.getAffineY(), eCParameterSpec);
    }

    public static boolean isPointOnCurve(BigInteger bigInteger, BigInteger bigInteger2, ECParameterSpec eCParameterSpec) {
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        BigInteger bigInteger3 = ellipticCurve.getA();
        BigInteger bigInteger4 = ellipticCurve.getB();
        BigInteger bigInteger5 = ((ECFieldFp)ellipticCurve.getField()).getP();
        BigInteger bigInteger6 = bigInteger2.pow(2).mod(bigInteger5);
        BigInteger bigInteger7 = bigInteger.pow(3).add(bigInteger3.multiply(bigInteger)).add(bigInteger4).mod(bigInteger5);
        return bigInteger6.equals(bigInteger7);
    }

    private ECChecks() {
    }
}

