/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWSProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;

public abstract class ECDSAProvider
extends BaseJWSProvider {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<Curve> SUPPORTED_CURVES;

    protected ECDSAProvider(JWSAlgorithm jWSAlgorithm) throws JOSEException {
        super(Collections.singleton(jWSAlgorithm));
        if (!SUPPORTED_ALGORITHMS.contains(jWSAlgorithm)) {
            throw new JOSEException("Unsupported EC DSA algorithm: " + jWSAlgorithm);
        }
    }

    public JWSAlgorithm supportedECDSAAlgorithm() {
        return this.supportedJWSAlgorithms().iterator().next();
    }

    static {
        LinkedHashSet<JWSAlgorithm> linkedHashSet = new LinkedHashSet<JWSAlgorithm>();
        linkedHashSet.add(JWSAlgorithm.ES256);
        linkedHashSet.add(JWSAlgorithm.ES256K);
        linkedHashSet.add(JWSAlgorithm.ES384);
        linkedHashSet.add(JWSAlgorithm.ES512);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
        LinkedHashSet<Curve> linkedHashSet2 = new LinkedHashSet<Curve>();
        linkedHashSet2.add(Curve.P_256);
        linkedHashSet2.add(Curve.SECP256K1);
        linkedHashSet2.add(Curve.P_384);
        linkedHashSet2.add(Curve.P_521);
        SUPPORTED_CURVES = Collections.unmodifiableSet(linkedHashSet2);
    }
}

