/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca.JWEJCAContext;

public abstract class BaseJWEProvider
implements JWEProvider {
    private static final Set<String> ACCEPTABLE_CEK_ALGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AES", "ChaCha20")));
    private final Set<JWEAlgorithm> algs;
    private final Set<EncryptionMethod> encs;
    private final JWEJCAContext jcaContext = new JWEJCAContext();
    private final SecretKey cek;

    public BaseJWEProvider(Set<JWEAlgorithm> set, Set<EncryptionMethod> set2) {
        this(set, set2, null);
    }

    public BaseJWEProvider(Set<JWEAlgorithm> set, Set<EncryptionMethod> set2, SecretKey secretKey) {
        if (set == null) {
            throw new IllegalArgumentException("The supported JWE algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(set);
        if (set2 == null) {
            throw new IllegalArgumentException("The supported encryption methods must not be null");
        }
        this.encs = set2;
        if (!(secretKey == null || set.size() <= 1 || secretKey.getAlgorithm() != null && ACCEPTABLE_CEK_ALGS.contains(secretKey.getAlgorithm()))) {
            throw new IllegalArgumentException("The algorithm of the content encryption key (CEK) must be AES or ChaCha20");
        }
        this.cek = secretKey;
    }

    @Override
    public Set<JWEAlgorithm> supportedJWEAlgorithms() {
        return this.algs;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return this.encs;
    }

    @Override
    public JWEJCAContext getJCAContext() {
        return this.jcaContext;
    }

    protected boolean isCEKProvided() {
        return this.cek != null;
    }

    protected SecretKey getCEK(EncryptionMethod encryptionMethod) throws JOSEException {
        return this.isCEKProvided() || encryptionMethod == null ? this.cek : ContentCryptoProvider.generateCEK(encryptionMethod, this.jcaContext.getSecureRandom());
    }
}

